/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverConfig
extends WebDriverConfig<ChromeDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeDriverConfig.class);
    private static final Map<String, ChromeDriverService> services = new ConcurrentHashMap<String, ChromeDriverService>();

    Map<String, ChromeDriverService> getServices() {
        return services;
    }

    @Override
    protected ChromeDriver createBrowser() {
        ChromeDriverService service = this.getThreadService();
        ChromeOptions options = this.createChromeOptions();
        return service != null ? new ChromeDriver(service, options) : null;
    }

    @Override
    public void quitBrowser(ChromeDriver browser) {
        super.quitBrowser(browser);
        ChromeDriverService service = services.remove(this.currentThreadName());
        if (service != null && service.isRunning()) {
            service.stop();
        }
    }

    private ChromeDriverService getThreadService() {
        ChromeDriverService service = services.get(this.currentThreadName());
        if (service != null) {
            return service;
        }
        try {
            service = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingDriverExecutable(new File(this.getDriverPath()))).build();
            service.start();
            services.put(this.currentThreadName(), service);
        }
        catch (IOException e) {
            LOGGER.error("Failed to start chrome service");
            service = null;
        }
        return service;
    }
}

