/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeDriverConfig
extends WebDriverConfig<EdgeDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeDriverConfig.class);
    private static final Map<String, EdgeDriverService> services = new ConcurrentHashMap<String, EdgeDriverService>();

    Map<String, EdgeDriverService> getServices() {
        return services;
    }

    @Override
    protected EdgeDriver createBrowser() {
        EdgeDriverService service = this.getThreadService();
        EdgeOptions options = this.createEdgeOptions();
        return service != null ? new EdgeDriver(service, options) : null;
    }

    @Override
    public void quitBrowser(EdgeDriver browser) {
        super.quitBrowser(browser);
        EdgeDriverService service = services.remove(this.currentThreadName());
        if (service != null && service.isRunning()) {
            service.stop();
        }
    }

    private EdgeDriverService getThreadService() {
        EdgeDriverService service = services.get(this.currentThreadName());
        if (service != null) {
            return service;
        }
        try {
            service = (EdgeDriverService)((EdgeDriverService.Builder)new EdgeDriverService.Builder().usingDriverExecutable(new File(this.getDriverPath()))).build();
            service.start();
            services.put(this.currentThreadName(), service);
        }
        catch (IOException e) {
            LOGGER.error("Failed to start edge service");
            service = null;
        }
        return service;
    }
}

