/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirefoxDriverConfig
extends WebDriverConfig<FirefoxDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger log = LoggerFactory.getLogger(FirefoxDriverConfig.class);
    private static final Map<String, FirefoxDriverService> services = new ConcurrentHashMap<String, FirefoxDriverService>();
    private Boolean bUnitTests = false;

    public void enableUnitTests() {
        this.bUnitTests = true;
    }

    Map<String, FirefoxDriverService> getServices() {
        return services;
    }

    @Override
    protected FirefoxDriver createBrowser() {
        FirefoxDriverService service = this.getThreadService();
        FirefoxOptions options = this.createFirefoxOptions();
        return service != null ? new FirefoxDriver(service, options) : null;
    }

    private FirefoxDriverService getThreadService() {
        Object service = services.get(this.currentThreadName());
        if (service != null) {
            return service;
        }
        try {
            service = this.bUnitTests != false ? GeckoDriverService.createDefaultService() : (FirefoxDriverService)((GeckoDriverService.Builder)new GeckoDriverService.Builder().usingDriverExecutable(new File(this.getDriverPath()))).build();
            service.start();
            services.put(this.currentThreadName(), (FirefoxDriverService)service);
        }
        catch (IOException e) {
            log.error("Failed to start Firefox service");
            service = null;
        }
        return service;
    }
}

