/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetExplorerDriverConfig
extends WebDriverConfig<InternetExplorerDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternetExplorerDriverConfig.class);
    private static final Map<String, InternetExplorerDriverService> services = new ConcurrentHashMap<String, InternetExplorerDriverService>();

    Map<String, InternetExplorerDriverService> getServices() {
        return services;
    }

    @Override
    protected InternetExplorerDriver createBrowser() {
        InternetExplorerDriverService service = this.getThreadService();
        InternetExplorerOptions ieOptions = this.createIEOptions();
        return service != null ? new InternetExplorerDriver(service, ieOptions) : null;
    }

    @Override
    public void quitBrowser(InternetExplorerDriver browser) {
        super.quitBrowser(browser);
        InternetExplorerDriverService service = services.remove(this.currentThreadName());
        if (service != null && service.isRunning()) {
            service.stop();
        }
    }

    private InternetExplorerDriverService getThreadService() {
        InternetExplorerDriverService service = services.get(this.currentThreadName());
        if (service != null) {
            return service;
        }
        try {
            service = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)new InternetExplorerDriverService.Builder().usingDriverExecutable(new File(this.getDriverPath()))).build();
            service.start();
            services.put(this.currentThreadName(), service);
        }
        catch (IOException e) {
            LOGGER.error("Failed to start IE service");
            service = null;
        }
        return service;
    }
}

