/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDriverConfig
extends WebDriverConfig<RemoteWebDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDriverConfig.class);
    private static final String LOCAL_FILE_DETECTOR = "RemoteDriverConfig.general.selenium.file.detector";
    private static final String REMOTE_CAPABILITY = "RemoteDriverConfig.general.selenium.capability";
    private static final String REMOTE_SELENIUM_GRID_URL = "RemoteDriverConfig.general.selenium.grid.url";
    private static final String BROWSER_LANGUAGE = "RemoteDriverConfig.browser.language";

    @Override
    protected RemoteWebDriver createBrowser() {
        try {
            RemoteWebDriver driver = new RemoteWebDriver(new URL(this.getSeleniumGridUrl()), this.createCapabilities());
            if (this.isLocalFileDectedor()) {
                driver.setFileDetector((FileDetector)new LocalFileDetector());
            }
            LOGGER.debug("Created remote web driver.");
            return driver;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    Capabilities createCapabilities() {
        this.setAcceptInsecureCerts(true);
        ChromeOptions caps = null;
        switch (this.getCapability()) {
            case CHROME: {
                caps = this.createChromeOptions();
                break;
            }
            case EDGE: {
                caps = this.createEdgeOptions();
                break;
            }
            case FIREFOX: {
                caps = this.createFirefoxOptions();
                break;
            }
            case INTERNET_EXPLORER: {
                caps = this.createIEOptions();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such capability");
            }
        }
        return caps;
    }

    public RemoteCapability getCapability() {
        return RemoteCapability.valueOf(this.getPropertyAsString(REMOTE_CAPABILITY));
    }

    public void setCapability(RemoteCapability selectedCapability) {
        this.setProperty(REMOTE_CAPABILITY, selectedCapability.name());
    }

    public String getSeleniumGridUrl() {
        return this.getPropertyAsString(REMOTE_SELENIUM_GRID_URL);
    }

    public void setSeleniumGridUrl(String seleniumUrl) {
        this.setProperty(REMOTE_SELENIUM_GRID_URL, seleniumUrl);
    }

    public boolean isLocalFileDectedor() {
        return this.getPropertyAsBoolean(LOCAL_FILE_DETECTOR);
    }

    public void setLocalFileDetector(boolean enabled) {
        this.setProperty(LOCAL_FILE_DETECTOR, enabled);
    }

    public void setBrowserLanguage(String browserLanguage) {
        this.setProperty(BROWSER_LANGUAGE, browserLanguage);
    }

    public String getBrowserLanguage() {
        return this.getPropertyAsString(BROWSER_LANGUAGE, "zh-CN");
    }

    @Override
    protected ChromeOptions createChromeOptions() {
        ChromeOptions options = super.createChromeOptions();
        HashMap<String, CharSequence> prefs = new HashMap<String, CharSequence>();
        prefs.put("intl.accept_languages", StringUtils.defaultIfBlank((CharSequence)this.getBrowserLanguage(), (CharSequence)"zh-CN"));
        options.setExperimentalOption("prefs", prefs);
        options.addArguments(new String[]{String.format("--lang=%s", StringUtils.defaultIfBlank((CharSequence)this.getBrowserLanguage(), (CharSequence)"zh-CN"))});
        options.addArguments(new String[]{"--enable-logging --v=1"});
        options.addArguments(new String[]{"--ignore-certificate-errors"});
        return options;
    }

    @Override
    protected FirefoxOptions createFirefoxOptions() {
        FirefoxOptions options = super.createFirefoxOptions();
        FirefoxProfile profile = options.getProfile();
        profile.setPreference("intl.accept_languages", (Object)StringUtils.defaultIfBlank((CharSequence)this.getBrowserLanguage(), (CharSequence)"zh-CN"));
        options.addArguments(new String[]{String.format("--lang=%s", StringUtils.defaultIfBlank((CharSequence)this.getBrowserLanguage(), (CharSequence)"zh-CN"))});
        options.setProfile(profile);
        options.addArguments(new String[]{"--ignore-certificate-errors"});
        return options;
    }
}

