/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyFactory;
import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyHostPort;
import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyType;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverConfig<T extends WebDriver>
extends ConfigTestElement
implements LoopIterationListener,
ThreadListener {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverConfig.class);
    public static final String BROWSER = "Browser";
    private static final String DRIVER_PATH = "WebDriverConfig.driver_path";
    private static final String ACCEPT_INSECURE_CERTS = "WebDriverConfig.acceptinsecurecerts";
    private static final String ENABLE_HEADLESS = "WebDriverConfig.headless";
    private static final String MAXIMIZE_WINDOW = "WebDriverConfig.maximize_browser";
    private static final String RECREATE_ON_ITERATION_START = "WebDriverConfig.reset_per_iteration";
    private static final String DEV_MODE = "WebDriverConfig.dev_mode";
    private static final String CHROME_ADDITIONAL_ARGS = "ChromeDriverConfig.additional_args";
    private static final String CHROME_BINARY_PATH = "ChromeDriverConfig.binary_path";
    private static final String EDGE_ADDITIONAL_ARGS = "EdgeDriverConfig.additional_args";
    private static final String EDGE_BINARY_PATH = "EdgeDriverConfig.binary_path";
    private static final String GENERAL_USERAGENT_OVERRIDE = "FirefoxDriverConfig.general.useragent.override";
    private static final String ENABLE_USERAGENT_OVERRIDE = "FirefoxDriverConfig.general.useragent.override.enabled";
    private static final String ENABLE_NTML = "FirefoxDriverConfig.network.negotiate-auth.allow-insecure-ntlm-v1";
    private static final String EXTENSIONS_TO_LOAD = "FirefoxDriverConfig.general.extensions";
    private static final String PREFERENCES = "FirefoxDriverConfig.general.preferences";
    private static final String FILE_UPLOAD_DIALOG_TIMEOUT = "InternetExplorerDriverConfig.file_upload_dialog_timeout";
    private static final String ENSURE_CLEAN_SESSION = "InternetExplorerDriverConfig.ensure_clean_session";
    private static final String IGNORE_PROTECTED_MODE = "InternetExplorerDriverConfig.ignore_protected_mode";
    private static final String SILENT = "InternetExplorerDriverConfig.silent";
    private static final String INITIAL_IE_URL = "InternetExplorerDriverConfig.initial_browser_url";
    private static final String PROXY_PAC_URL = "WebDriverConfig.proxy_pac_url";
    private static final String HTTP_HOST = "WebDriverConfig.http_host";
    private static final String HTTP_PORT = "WebDriverConfig.http_port";
    private static final String USE_HTTP_FOR_ALL_PROTOCOLS = "WebDriverConfig.use_http_for_all_protocols";
    private static final String HTTPS_HOST = "WebDriverConfig.https_host";
    private static final String HTTPS_PORT = "WebDriverConfig.https_port";
    private static final String FTP_HOST = "WebDriverConfig.ftp_host";
    private static final String FTP_PORT = "WebDriverConfig.ftp_port";
    private static final String SOCKS_HOST = "WebDriverConfig.socks_host";
    private static final String SOCKS_PORT = "WebDriverConfig.socks_port";
    private static final String NO_PROXY = "WebDriverConfig.no_proxy";
    private static final String PROXY_TYPE = "WebDriverConfig.proxy_type";
    private static final Map<String, WebDriver> webdrivers = new ConcurrentHashMap<String, WebDriver>();
    private static String browserName;
    private final transient ProxyFactory proxyFactory;

    Map<String, WebDriver> getThreadBrowsers() {
        return webdrivers;
    }

    void clearThreadBrowsers() {
        webdrivers.clear();
    }

    protected T getThreadBrowser() {
        return (T)webdrivers.get(this.currentThreadName());
    }

    protected T removeThreadBrowser() {
        return (T)webdrivers.remove(this.currentThreadName());
    }

    public static void setBrowserName(String name) {
        browserName = name;
    }

    public static String getBrowserName() {
        return browserName;
    }

    protected WebDriverConfig() {
        this(ProxyFactory.getInstance());
    }

    protected WebDriverConfig(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void threadStarted() {
        if (this.hasThreadBrowser()) {
            LOGGER.warn("Thread: " + this.currentThreadName() + " already has a WebDriver(" + this.getThreadBrowser() + ") associated with it. ThreadGroup can only contain a single WebDriverConfig.");
            return;
        }
        T browser = this.getPreparedBrowser();
        this.setThreadBrowser(browser);
        Runtime.getRuntime().addShutdownHook(new Thread((WebDriver)browser){
            final /* synthetic */ WebDriver val$browser;
            {
                this.val$browser = webDriver;
            }

            @Override
            public void run() {
                WebDriverConfig.this.quitBrowser(this.val$browser);
            }
        });
    }

    protected boolean hasThreadBrowser() {
        if (webdrivers.containsKey(this.currentThreadName())) {
            WebDriver browser = webdrivers.get(this.currentThreadName());
            try {
                browser.getCurrentUrl();
                return true;
            }
            catch (Exception ex) {
                LOGGER.warn("Old browser object is inaccessible, will create new", (Throwable)ex);
                webdrivers.remove(this.currentThreadName());
            }
        }
        return false;
    }

    protected void setThreadBrowser(T browser) {
        if (browser != null) {
            webdrivers.put(this.currentThreadName(), (WebDriver)browser);
            if (this.getThreadContext().getVariables() != null) {
                this.getThreadContext().getVariables().putObject(BROWSER, browser);
            }
        }
    }

    protected String currentThreadName() {
        return Thread.currentThread().getName();
    }

    public void iterationStart(LoopIterationEvent loopIterationEvent) {
        if (this.isRecreateBrowserOnIterationStart() && !this.isDevMode()) {
            T browser = this.getThreadBrowser();
            this.quitBrowser(browser);
            this.setThreadBrowser(this.getPreparedBrowser());
            LOGGER.info("Created browser object: " + browser);
        }
    }

    protected void quitBrowser(T browser) {
        if (browser != null) {
            try {
                browser.quit();
            }
            catch (SessionNotCreatedException e) {
                LOGGER.warn("Attempting to quit browser instance that has already exited.");
            }
        }
    }

    private T getPreparedBrowser() {
        T browser = this.createBrowser();
        if (this.isBrowserMaximized() && (WebDriverConfig.getBrowserName() == "firefox" || WebDriverConfig.getBrowserName() == "internet explorer")) {
            browser.manage().window().maximize();
        }
        return browser;
    }

    protected abstract T createBrowser();

    public Proxy createProxy() {
        switch (this.getProxyType()) {
            case PROXY_PAC: {
                return this.proxyFactory.getConfigUrlProxy(this.getProxyPacUrl());
            }
            case DIRECT: {
                return this.proxyFactory.getDirectProxy();
            }
            case AUTO_DETECT: {
                return this.proxyFactory.getAutodetectProxy();
            }
            case MANUAL: {
                if (this.isUseHttpSettingsForAllProtocols()) {
                    ProxyHostPort proxy = new ProxyHostPort(this.getHttpHost(), this.getHttpPort());
                    return this.proxyFactory.getManualProxy(proxy, proxy, proxy, proxy, this.getNoProxyHost());
                }
                ProxyHostPort http = new ProxyHostPort(this.getHttpHost(), this.getHttpPort());
                ProxyHostPort https = new ProxyHostPort(this.getHttpsHost(), this.getHttpsPort());
                ProxyHostPort ftp = new ProxyHostPort(this.getFtpHost(), this.getFtpPort());
                ProxyHostPort socks = new ProxyHostPort(this.getSocksHost(), this.getSocksPort());
                return this.proxyFactory.getManualProxy(http, https, ftp, socks, this.getNoProxyHost());
            }
        }
        return this.proxyFactory.getSystemProxy();
    }

    public void threadFinished() {
        if (!this.isDevMode()) {
            T browser = this.removeThreadBrowser();
            this.quitBrowser(browser);
        }
    }

    protected ChromeOptions createChromeOptions() {
        String binaryPath;
        String additionalArgs;
        ChromeOptions options = new ChromeOptions();
        if (this.isBrowserMaximized()) {
            options.addArguments(new String[]{"--start-maximized"});
        }
        if (this.isHeadless()) {
            options.addArguments(new String[]{"--headless=new"});
        }
        if (null != (additionalArgs = this.trimmed(this.getChromeAdditionalArgs())) && !additionalArgs.isEmpty()) {
            options.addArguments(additionalArgs.split("\\s+"));
        }
        if (null != (binaryPath = this.trimmed(this.getChromeBinaryPath())) && !binaryPath.isEmpty()) {
            options.setBinary(binaryPath);
        }
        this.setSharedCaps((AbstractDriverOptions<?>)options);
        return options;
    }

    protected EdgeOptions createEdgeOptions() {
        String binaryPath;
        String additionalArgs;
        EdgeOptions options = new EdgeOptions();
        if (this.isBrowserMaximized()) {
            options.addArguments(new String[]{"--start-maximized"});
        }
        if (this.isHeadless()) {
            options.addArguments(new String[]{"--headless=new"});
        }
        if (null != (additionalArgs = this.trimmed(this.getEdgeAdditionalArgs())) && !additionalArgs.isEmpty()) {
            options.addArguments(additionalArgs.split("\\s+"));
        }
        if (null != (binaryPath = this.trimmed(this.getEdgeBinaryPath())) && !binaryPath.isEmpty()) {
            options.setBinary(binaryPath);
        }
        this.setSharedCaps((AbstractDriverOptions<?>)options);
        return options;
    }

    protected FirefoxOptions createFirefoxOptions() {
        FirefoxOptions options = new FirefoxOptions();
        if (this.isHeadless()) {
            options.addArguments(new String[]{"--headless"});
        }
        options.setProfile(this.createProfile());
        this.setSharedCaps((AbstractDriverOptions<?>)options);
        return options;
    }

    private FirefoxProfile createProfile() {
        String ntlmOverride;
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("app.update.enabled", (Object)false);
        String userAgentOverride = this.getUserAgentOverride();
        if (StringUtils.isNotEmpty((CharSequence)userAgentOverride)) {
            profile.setPreference("general.useragent.override", (Object)userAgentOverride);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ntlmOverride = this.getNtlmSetting()))) {
            profile.setPreference("network.negotiate-auth.allow-insecure-ntlm-v1", (Object)true);
        }
        this.addExtensions(profile);
        this.setPreferences(profile);
        return profile;
    }

    private void addExtensions(FirefoxProfile profile) {
        JMeterProperty property = this.getProperty(EXTENSIONS_TO_LOAD);
        if (property instanceof NullProperty) {
            return;
        }
        CollectionProperty rows = (CollectionProperty)property;
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String filename = ((JMeterProperty)row.get(0)).getStringValue();
            profile.addExtension(new File(filename));
        }
    }

    private void setPreferences(FirefoxProfile profile) {
        JMeterProperty property = this.getProperty(PREFERENCES);
        if (property instanceof NullProperty) {
            return;
        }
        CollectionProperty rows = (CollectionProperty)property;
        block8: for (int i = 0; i < rows.size(); ++i) {
            String value;
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String name = ((JMeterProperty)row.get(0)).getStringValue();
            switch (value = ((JMeterProperty)row.get(1)).getStringValue()) {
                case "true": {
                    profile.setPreference(name, (Object)true);
                    continue block8;
                }
                case "false": {
                    profile.setPreference(name, (Object)false);
                    continue block8;
                }
                default: {
                    profile.setPreference(name, (Object)value);
                }
            }
        }
    }

    InternetExplorerOptions createIEOptions() {
        InternetExplorerOptions options = new InternetExplorerOptions();
        options.attachToEdgeChrome();
        options.withInitialBrowserUrl(this.getInitialIeUrl());
        options.waitForUploadDialogUpTo(Duration.ofMillis(this.getFileUploadDialogTimeout()));
        if (this.isEnsureCleanSession()) {
            options.destructivelyEnsureCleanSession();
        }
        if (this.isIgnoreProtectedMode()) {
            options.introduceFlakinessByIgnoringSecurityDomains();
        }
        if (this.isSilent()) {
            options.setCapability("silent", true);
        }
        this.setSharedCaps((AbstractDriverOptions<?>)options);
        return options;
    }

    public void setSharedCaps(AbstractDriverOptions<?> caps) {
        caps.setAcceptInsecureCerts(this.isAcceptInsecureCerts());
        caps.setProxy(this.createProxy());
    }

    public String getChromeBinaryPath() {
        return this.getPropertyAsString(CHROME_BINARY_PATH);
    }

    public void setChromeBinaryPath(String binaryPath) {
        this.setProperty(CHROME_BINARY_PATH, binaryPath);
    }

    public String getEdgeBinaryPath() {
        return this.getPropertyAsString(EDGE_BINARY_PATH);
    }

    public void setEdgeBinaryPath(String binaryPath) {
        this.setProperty(EDGE_BINARY_PATH, binaryPath);
    }

    public String getDriverPath() {
        return this.getPropertyAsString(DRIVER_PATH);
    }

    public void setDriverPath(String path) {
        this.setProperty(DRIVER_PATH, path);
    }

    public String getChromeAdditionalArgs() {
        return this.getPropertyAsString(CHROME_ADDITIONAL_ARGS);
    }

    public void setChromeAdditionalArgs(String additionalArgs) {
        this.setProperty(CHROME_ADDITIONAL_ARGS, additionalArgs);
    }

    public String getEdgeAdditionalArgs() {
        return this.getPropertyAsString(EDGE_ADDITIONAL_ARGS);
    }

    public void setEdgeAdditionalArgs(String additionalArgs) {
        this.setProperty(EDGE_ADDITIONAL_ARGS, additionalArgs);
    }

    public String getFtpHost() {
        return this.getPropertyAsString(FTP_HOST);
    }

    public void setFtpHost(String host) {
        this.setProperty(FTP_HOST, host);
    }

    public int getFtpPort() {
        return this.getPropertyAsInt(FTP_PORT);
    }

    public void setFtpPort(int port) {
        this.setProperty(FTP_PORT, port);
    }

    public String getHttpHost() {
        return this.getPropertyAsString(HTTP_HOST);
    }

    public void setHttpHost(String host) {
        this.setProperty(HTTP_HOST, host);
    }

    public int getHttpPort() {
        return this.getPropertyAsInt(HTTP_PORT);
    }

    public void setHttpPort(int port) {
        this.setProperty(HTTP_PORT, port);
    }

    public String getHttpsHost() {
        return this.getPropertyAsString(HTTPS_HOST);
    }

    public void setHttpsHost(String httpsHost) {
        this.setProperty(HTTPS_HOST, httpsHost);
    }

    public int getHttpsPort() {
        return this.getPropertyAsInt(HTTPS_PORT);
    }

    public void setHttpsPort(int port) {
        this.setProperty(HTTPS_PORT, port);
    }

    public String getNoProxyHost() {
        return this.getPropertyAsString(NO_PROXY);
    }

    public void setNoProxyHost(String noProxyHostList) {
        this.setProperty(NO_PROXY, noProxyHostList);
    }

    public String getProxyPacUrl() {
        return this.getPropertyAsString(PROXY_PAC_URL);
    }

    public void setProxyPacUrl(String pacUrl) {
        this.setProperty(PROXY_PAC_URL, pacUrl);
    }

    public ProxyType getProxyType() {
        return ProxyType.valueOf(this.getPropertyAsString(PROXY_TYPE, ProxyType.SYSTEM.name()));
    }

    public void setProxyType(ProxyType type) {
        this.setProperty(PROXY_TYPE, type.name());
    }

    public String getSocksHost() {
        return this.getPropertyAsString(SOCKS_HOST);
    }

    public void setSocksHost(String host) {
        this.setProperty(SOCKS_HOST, host);
    }

    public int getSocksPort() {
        return this.getPropertyAsInt(SOCKS_PORT);
    }

    public void setSocksPort(int port) {
        this.setProperty(SOCKS_PORT, port);
    }

    public boolean isAcceptInsecureCerts() {
        return this.getPropertyAsBoolean(ACCEPT_INSECURE_CERTS);
    }

    public void setAcceptInsecureCerts(boolean enabled) {
        this.setProperty(ACCEPT_INSECURE_CERTS, enabled);
    }

    public boolean isUseHttpSettingsForAllProtocols() {
        return this.getPropertyAsBoolean(USE_HTTP_FOR_ALL_PROTOCOLS, true);
    }

    public void setUseHttpSettingsForAllProtocols(boolean override) {
        this.setProperty(USE_HTTP_FOR_ALL_PROTOCOLS, override);
    }

    public boolean isHeadless() {
        return this.getPropertyAsBoolean(ENABLE_HEADLESS);
    }

    public void setHeadless(boolean headless) {
        this.setProperty(ENABLE_HEADLESS, headless);
    }

    public boolean isBrowserMaximized() {
        return this.getPropertyAsBoolean(MAXIMIZE_WINDOW, false);
    }

    public void setBrowserMaximized(boolean state) {
        this.setProperty(MAXIMIZE_WINDOW, state);
    }

    public boolean isDevMode() {
        return this.getPropertyAsBoolean(DEV_MODE);
    }

    public void setDevMode(boolean devMode) {
        this.setProperty(DEV_MODE, devMode);
    }

    public boolean isRecreateBrowserOnIterationStart() {
        return this.getPropertyAsBoolean(RECREATE_ON_ITERATION_START);
    }

    public void setRecreateBrowserOnIterationStart(boolean recreate) {
        this.setProperty(RECREATE_ON_ITERATION_START, recreate);
    }

    public boolean isUserAgentOverridden() {
        return this.getPropertyAsBoolean(ENABLE_USERAGENT_OVERRIDE);
    }

    public void setUserAgentOverridden(boolean userAgentOverridden) {
        this.setProperty(ENABLE_USERAGENT_OVERRIDE, userAgentOverridden);
    }

    public String getUserAgentOverride() {
        return this.getPropertyAsString(GENERAL_USERAGENT_OVERRIDE);
    }

    public void setUserAgentOverride(String userAgent) {
        this.setProperty(GENERAL_USERAGENT_OVERRIDE, userAgent);
    }

    public JMeterProperty getExtensions() {
        return this.getProperty(EXTENSIONS_TO_LOAD);
    }

    public void setExtensions(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)model, (String)EXTENSIONS_TO_LOAD);
        this.setProperty((JMeterProperty)prop);
    }

    public String getNtlmSetting() {
        return this.getPropertyAsString(ENABLE_NTML);
    }

    public void setNtlmSetting(boolean ntlm) {
        this.setProperty(ENABLE_NTML, ntlm);
    }

    public JMeterProperty getPreferences() {
        return this.getProperty(PREFERENCES);
    }

    public void setPreferences(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)model, (String)PREFERENCES);
        this.setProperty((JMeterProperty)prop);
    }

    public void setFileUploadDialogTimeout(int timeout) {
        this.setProperty(FILE_UPLOAD_DIALOG_TIMEOUT, timeout);
    }

    public int getFileUploadDialogTimeout() {
        return this.getPropertyAsInt(FILE_UPLOAD_DIALOG_TIMEOUT);
    }

    public boolean isEnsureCleanSession() {
        return this.getPropertyAsBoolean(ENSURE_CLEAN_SESSION, false);
    }

    public void setEnsureCleanSession(boolean state) {
        this.setProperty(ENSURE_CLEAN_SESSION, state);
    }

    public boolean isIgnoreProtectedMode() {
        return this.getPropertyAsBoolean(IGNORE_PROTECTED_MODE, false);
    }

    public void setIgnoreProtectedMode(boolean state) {
        this.setProperty(IGNORE_PROTECTED_MODE, state);
    }

    public boolean isSilent() {
        return this.getPropertyAsBoolean(SILENT, false);
    }

    public void setSilent(boolean state) {
        this.setProperty(SILENT, state);
    }

    public String getInitialIeUrl() {
        return this.getPropertyAsString(INITIAL_IE_URL);
    }

    public void setInitialIeUrl(String webUrl) {
        this.setProperty(INITIAL_IE_URL, webUrl);
    }

    private String trimmed(String str) {
        return null == str ? null : str.trim();
    }
}

