/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import com.googlecode.jmeter.plugins.webdriver.config.RemoteDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.testelement.TestElement;

public class RemoteDriverConfigGui
extends WebDriverConfigGui
implements ItemListener,
FocusListener {
    private static final long serialVersionUID = 100L;

    @Override
    String browserName() {
        WebDriverConfig.setBrowserName("Remote");
        return "Remote";
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Remote Driver Config");
    }

    @Override
    protected String getWikiPage() {
        return "RemoteDriverConfig";
    }

    @Override
    protected boolean isBrowser() {
        return false;
    }

    @Override
    protected boolean isProxyEnabled() {
        return true;
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    public TestElement createTestElement() {
        RemoteDriverConfig element = new RemoteDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof RemoteDriverConfig) {
            RemoteDriverConfig config = (RemoteDriverConfig)element;
            config.setSeleniumGridUrl(this.remoteSeleniumGridText.getText());
            config.setCapability((RemoteCapability)((Object)this.capabilitiesComboBox.getSelectedItem()));
            config.setLocalFileDetector(this.localFileDetector.isSelected());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.remoteSeleniumGridText.setText("");
        this.capabilitiesComboBox.setSelectedIndex(1);
        this.localFileDetector.setSelected(false);
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof RemoteDriverConfig) {
            RemoteDriverConfig config = (RemoteDriverConfig)element;
            this.remoteSeleniumGridText.setText(config.getSeleniumGridUrl());
            this.capabilitiesComboBox.setSelectedItem((Object)config.getCapability());
            this.localFileDetector.setSelected(config.isLocalFileDectedor());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.remoteSeleniumGridText.equals(e.getComponent()) && !this.isValidUrl(this.remoteSeleniumGridText.getText())) {
            this.RemoteErrorMsg.setText("The selenium grid URL is malformed");
        } else {
            this.RemoteErrorMsg.setText("");
        }
        if (this.initialBrowserUrl.equals(e.getComponent()) && !this.isValidUrl(this.initialBrowserUrl.getText())) {
            this.IEerrorMsg.setText("The URL is malformed");
        } else {
            this.IEerrorMsg.setText("");
        }
    }
}

