/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.Grid;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;

public abstract class WebDriverConfigGui
extends AbstractConfigGui
implements ItemListener {
    private static final long serialVersionUID = 100L;
    private static final int Default_FileUploadDialogTimeout = 1000;
    private static final String DEFAULT_NO_PROXY_LIST = "localhost";
    private static final int DEFAULT_PROXY_PORT = 8080;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance();
    private static final int PROXY_FIELD_INDENT = 28;
    JTextField driverPath;
    JCheckBox acceptInsecureCerts;
    JCheckBox maximizeBrowser;
    JCheckBox headless;
    JCheckBox devMode;
    JCheckBox recreateBrowserOnIterationStart;
    JTextField remoteSeleniumGridText;
    JComboBox<?> capabilitiesComboBox;
    JCheckBox localFileDetector;
    JLabel RemoteErrorMsg;
    JTextField chromeAdditionalArgs;
    JTextField chromeBinaryPath;
    JTextField edgeAdditionalArgs;
    JTextField edgeBinaryPath;
    JTextField userAgentOverrideText;
    JCheckBox userAgentOverrideCheckbox;
    JCheckBox ntlmOverrideCheckbox;
    private Grid extensions;
    private Grid preferences;
    JFormattedTextField fileUploadDialogTimeout;
    JCheckBox ensureCleanSession;
    JCheckBox ignoreProtectedMode;
    JCheckBox silent;
    JTextField initialBrowserUrl;
    JLabel IEerrorMsg;
    JRadioButton autoDetectProxy;
    JRadioButton directProxy;
    JTextField ftpProxyHost;
    JFormattedTextField ftpProxyPort;
    JTextField httpProxyHost;
    JFormattedTextField httpProxyPort;
    JTextField httpsProxyHost;
    JFormattedTextField httpsProxyPort;
    JRadioButton manualProxy;
    JTextArea noProxyList;
    JTextField pacUrl;
    JRadioButton pacUrlProxy;
    JTextField socksProxyHost;
    JFormattedTextField socksProxyPort;
    JRadioButton systemProxy;
    JCheckBox useHttpSettingsForAllProtocols;

    protected abstract String getWikiPage();

    abstract String browserName();

    protected boolean isBrowser() {
        return false;
    }

    protected boolean isProxyEnabled() {
        return false;
    }

    public WebDriverConfigGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)this.getWikiPage()), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        switch (this.browserName()) {
            case "chrome": {
                tabbedPane.add("Driver", this.createMainPanel());
                tabbedPane.add("Options", this.crteChromeOptionsPanel());
                break;
            }
            case "edge": {
                tabbedPane.add("Driver", this.createMainPanel());
                tabbedPane.add("Options", this.crteEdgeOptionsPanel());
                break;
            }
            case "firefox": {
                tabbedPane.add("Driver", this.createMainPanel());
                tabbedPane.add("Options", this.crteFirefoxOptionsPanel());
                break;
            }
            case "internet explorer": {
                tabbedPane.add("Driver", this.createMainPanel());
                tabbedPane.add("Options", this.crteIEOptionsPanel());
                break;
            }
            case "HtmlUnit": {
                tabbedPane.add("HtmlUnit", this.createMainPanel());
                break;
            }
            case "Remote": {
                tabbedPane.add("Remote", this.createMainPanel());
                tabbedPane.add("Chrome", this.crteChromeOptionsPanel());
                tabbedPane.add("Edge", this.crteEdgeOptionsPanel());
                tabbedPane.add("Firefox", this.crteFirefoxOptionsPanel());
                tabbedPane.add("IE", this.crteIEOptionsPanel());
                break;
            }
        }
        if (this.isProxyEnabled()) {
            tabbedPane.add("Proxy", this.createProxyPanel());
        }
        this.add(tabbedPane, "Center");
    }

    protected JPanel createMainPanel() {
        VerticalPanel panel = new VerticalPanel();
        if (this.isBrowser()) {
            HorizontalPanel driverPanel = new HorizontalPanel();
            JLabel driverLabel = new JLabel("Path to Driver");
            driverPanel.add(driverLabel);
            this.driverPath = new JTextField();
            driverPanel.add(this.driverPath);
            panel.add((Component)driverPanel);
            this.devMode = new JCheckBox("Development Mode (keep browser opened on error)");
            this.devMode.setSelected(false);
            panel.add(this.devMode);
        }
        if (this.browserName().equals("Remote")) {
            JLabel remoteUrlLabel = new JLabel();
            remoteUrlLabel.setText("Selenium Grid URL");
            panel.add(remoteUrlLabel);
            this.remoteSeleniumGridText = new JTextField();
            this.remoteSeleniumGridText.setEnabled(true);
            this.remoteSeleniumGridText.addFocusListener((FocusListener)((Object)this));
            panel.add(this.remoteSeleniumGridText);
            this.RemoteErrorMsg = new JLabel();
            panel.add(this.RemoteErrorMsg);
            this.RemoteErrorMsg.setForeground(Color.red);
            JLabel capabilitiesLabel = new JLabel();
            capabilitiesLabel.setText("Capability");
            panel.add(capabilitiesLabel);
            this.capabilitiesComboBox = new JComboBox<RemoteCapability>(RemoteCapability.values());
            panel.add(this.capabilitiesComboBox);
            this.localFileDetector = new JCheckBox("Local File Detector");
            panel.add(this.localFileDetector);
        }
        this.acceptInsecureCerts = new JCheckBox("Accept Insecure Certs");
        panel.add(this.acceptInsecureCerts);
        if (!this.browserName().equals("HtmlUnit")) {
            if (!this.browserName().equals("internet explorer")) {
                this.headless = new JCheckBox("Headless");
                this.headless.setSelected(false);
                this.headless.setEnabled(true);
                panel.add(this.headless);
            }
            this.maximizeBrowser = new JCheckBox("Maximize browser window");
            this.maximizeBrowser.setSelected(true);
            panel.add(this.maximizeBrowser);
        }
        this.recreateBrowserOnIterationStart = new JCheckBox("Create a new Browser at the start of each iteration");
        this.recreateBrowserOnIterationStart.setSelected(false);
        panel.add(this.recreateBrowserOnIterationStart);
        return panel;
    }

    private JPanel crteChromeOptionsPanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        HorizontalPanel binaryPathPanel = new HorizontalPanel();
        JLabel binaryPathLabel = new JLabel("Binary (if in non-standard location)");
        this.chromeBinaryPath = new JTextField("");
        binaryPathPanel.add(binaryPathLabel);
        binaryPathPanel.add(this.chromeBinaryPath);
        browserPanel.add((Component)binaryPathPanel);
        HorizontalPanel additionalArgsPanel = new HorizontalPanel();
        JLabel additionalArgsLabel = new JLabel("Additional arguments");
        this.chromeAdditionalArgs = new JTextField();
        additionalArgsPanel.add(additionalArgsLabel);
        additionalArgsPanel.add(this.chromeAdditionalArgs);
        browserPanel.add((Component)additionalArgsPanel);
        return browserPanel;
    }

    private JPanel crteEdgeOptionsPanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        HorizontalPanel binaryPathPanel = new HorizontalPanel();
        JLabel binaryPathLabel = new JLabel("Binary (if in non-standard location)");
        this.edgeBinaryPath = new JTextField("");
        binaryPathPanel.add(binaryPathLabel);
        binaryPathPanel.add(this.edgeBinaryPath);
        browserPanel.add((Component)binaryPathPanel);
        HorizontalPanel additionalArgsPanel = new HorizontalPanel();
        JLabel additionalArgsLabel = new JLabel("Additional arguments");
        this.edgeAdditionalArgs = new JTextField();
        additionalArgsPanel.add(additionalArgsLabel);
        additionalArgsPanel.add(this.edgeAdditionalArgs);
        browserPanel.add((Component)additionalArgsPanel);
        return browserPanel;
    }

    private JPanel crteFirefoxOptionsPanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        this.userAgentOverrideCheckbox = new JCheckBox("Override User Agent");
        this.userAgentOverrideCheckbox.setSelected(false);
        this.userAgentOverrideCheckbox.setEnabled(true);
        this.userAgentOverrideCheckbox.addItemListener(this);
        browserPanel.add(this.userAgentOverrideCheckbox);
        this.userAgentOverrideText = new JTextField();
        this.userAgentOverrideText.setEnabled(false);
        browserPanel.add(this.userAgentOverrideText);
        this.ntlmOverrideCheckbox = new JCheckBox("Enable NTLM");
        this.ntlmOverrideCheckbox.setSelected(false);
        this.ntlmOverrideCheckbox.setEnabled(true);
        this.ntlmOverrideCheckbox.addItemListener(this);
        browserPanel.add(this.ntlmOverrideCheckbox);
        this.extensions = new Grid("Load Extensions", new String[]{"Path to XPI File"}, new Class[]{String.class}, (Object[])new String[]{""});
        browserPanel.add((Component)this.extensions);
        this.preferences = new Grid("Set Preferences", new String[]{"Name", "Value"}, new Class[]{String.class, String.class}, (Object[])new String[]{"", ""});
        browserPanel.add((Component)this.preferences);
        return browserPanel;
    }

    private JPanel crteIEOptionsPanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        JLabel initialUrlLabel = new JLabel();
        initialUrlLabel.setText("Initial Browser URL");
        browserPanel.add(initialUrlLabel);
        this.initialBrowserUrl = new JTextField();
        this.initialBrowserUrl.setEnabled(true);
        this.initialBrowserUrl.addFocusListener((FocusListener)((Object)this));
        browserPanel.add(this.initialBrowserUrl);
        this.IEerrorMsg = new JLabel();
        browserPanel.add(this.IEerrorMsg);
        this.IEerrorMsg.setForeground(Color.red);
        HorizontalPanel fileUploadDialogTimeoutPanel = new HorizontalPanel();
        JLabel fileUploadDialogTimeoutLabel = new JLabel("Wait for File Upload Dialog up to (ms)");
        fileUploadDialogTimeoutPanel.add(fileUploadDialogTimeoutLabel);
        this.fileUploadDialogTimeout = new JFormattedTextField(NUMBER_FORMAT);
        this.fileUploadDialogTimeout.setText(String.valueOf(1000));
        fileUploadDialogTimeoutPanel.add(this.fileUploadDialogTimeout);
        browserPanel.add((Component)fileUploadDialogTimeoutPanel);
        this.ensureCleanSession = new JCheckBox("Ensure Clean Session");
        this.ensureCleanSession.setSelected(false);
        browserPanel.add(this.ensureCleanSession);
        this.ignoreProtectedMode = new JCheckBox("Ignore Protected Mode Settings");
        this.ignoreProtectedMode.setSelected(false);
        browserPanel.add(this.ignoreProtectedMode);
        this.silent = new JCheckBox("Silent");
        this.silent.setSelected(false);
        browserPanel.add(this.silent);
        return browserPanel;
    }

    protected JPanel createProxyPanel() {
        VerticalPanel mainPanel = new VerticalPanel();
        ButtonGroup group = new ButtonGroup();
        this.directProxy = new JRadioButton("No proxy");
        group.add(this.directProxy);
        mainPanel.add(this.directProxy);
        this.autoDetectProxy = new JRadioButton("Auto-detect proxy settings for this network");
        group.add(this.autoDetectProxy);
        mainPanel.add(this.autoDetectProxy);
        this.systemProxy = new JRadioButton("Use system proxy settings");
        group.add(this.systemProxy);
        mainPanel.add(this.systemProxy);
        this.createManualProxy((JPanel)mainPanel, group);
        this.createPacUrlProxy((JPanel)mainPanel, group);
        this.systemProxy.setSelected(true);
        return mainPanel;
    }

    private void createManualProxy(JPanel panel, ButtonGroup group) {
        this.manualProxy = new JRadioButton("Manual proxy configuration");
        group.add(this.manualProxy);
        panel.add(this.manualProxy);
        this.manualProxy.addItemListener(this);
        VerticalPanel manualPanel = new VerticalPanel();
        manualPanel.setBorder(BorderFactory.createEmptyBorder(0, 28, 0, 0));
        this.httpProxyHost = new JTextField();
        this.httpProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.httpProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.httpProxyHost, this.httpProxyPort, "HTTP Proxy:"));
        this.useHttpSettingsForAllProtocols = new JCheckBox("Use HTTP proxy server for all protocols");
        this.useHttpSettingsForAllProtocols.setSelected(true);
        this.useHttpSettingsForAllProtocols.setEnabled(false);
        this.useHttpSettingsForAllProtocols.addItemListener(this);
        manualPanel.add(this.useHttpSettingsForAllProtocols);
        this.httpsProxyHost = new JTextField();
        this.httpsProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.httpsProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.httpsProxyHost, this.httpsProxyPort, "SSL Proxy:"));
        this.ftpProxyHost = new JTextField();
        this.ftpProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.ftpProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.ftpProxyHost, this.ftpProxyPort, "FTP Proxy:"));
        this.socksProxyHost = new JTextField();
        this.socksProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.socksProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.socksProxyHost, this.socksProxyPort, "SOCKS Proxy:"));
        manualPanel.add(this.createNoProxyPanel());
        panel.add((Component)manualPanel);
    }

    private JPanel createProxyHostAndPortPanel(JTextField proxyHost, JTextField proxyPort, String label) {
        HorizontalPanel httpPanel = new HorizontalPanel();
        JLabel httpProxyHostLabel = new JLabel(label);
        httpPanel.add(httpProxyHostLabel);
        httpPanel.add(proxyHost);
        proxyHost.setEnabled(false);
        JLabel httpProxyPortLabel = new JLabel("Port:");
        httpPanel.add(httpProxyPortLabel);
        httpPanel.add(proxyPort);
        proxyPort.setEnabled(false);
        return httpPanel;
    }

    private JPanel createNoProxyPanel() {
        VerticalPanel noProxyPanel = new VerticalPanel();
        JLabel noProxyListLabel = new JLabel("No Proxy for:");
        noProxyPanel.add(noProxyListLabel);
        this.noProxyList = new JTextArea(3, 10);
        this.noProxyList.setText(DEFAULT_NO_PROXY_LIST);
        this.noProxyList.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.noProxyList.setEnabled(false);
        noProxyPanel.add(this.noProxyList);
        JLabel noProxyExample = new JLabel("Example: .jmeter.org, .com.au, 192.168.1.0/24");
        noProxyPanel.add(noProxyExample);
        return noProxyPanel;
    }

    private void createPacUrlProxy(JPanel panel, ButtonGroup group) {
        this.pacUrlProxy = new JRadioButton("Automatic proxy configuration URL");
        group.add(this.pacUrlProxy);
        panel.add(this.pacUrlProxy);
        this.pacUrlProxy.addItemListener(this);
        HorizontalPanel pacUrlPanel = new HorizontalPanel();
        this.pacUrl = new JTextField();
        this.pacUrl.setEnabled(false);
        pacUrlPanel.add((Component)this.pacUrl, "Center");
        pacUrlPanel.setBorder(BorderFactory.createEmptyBorder(0, 28, 0, 0));
        panel.add((Component)pacUrlPanel);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.pacUrlProxy) {
            this.pacUrl.setEnabled(itemEvent.getStateChange() == 1);
        } else if (itemEvent.getSource() == this.manualProxy) {
            this.httpProxyHost.setEnabled(itemEvent.getStateChange() == 1);
            this.httpProxyPort.setEnabled(itemEvent.getStateChange() == 1);
            this.useHttpSettingsForAllProtocols.setEnabled(itemEvent.getStateChange() == 1);
            this.noProxyList.setEnabled(itemEvent.getStateChange() == 1);
            this.enableOtherProtocolsOnlyIfManualProxySelectedAndUseHttpSettingsIsNotSelected();
        } else if (itemEvent.getSource() == this.useHttpSettingsForAllProtocols) {
            this.enableOtherProtocolsOnlyIfManualProxySelectedAndUseHttpSettingsIsNotSelected();
        }
    }

    private void enableOtherProtocolsOnlyIfManualProxySelectedAndUseHttpSettingsIsNotSelected() {
        boolean enabledState = !this.useHttpSettingsForAllProtocols.isSelected() && this.manualProxy.isSelected();
        this.httpsProxyHost.setEnabled(enabledState);
        this.httpsProxyPort.setEnabled(enabledState);
        this.ftpProxyHost.setEnabled(enabledState);
        this.ftpProxyPort.setEnabled(enabledState);
        this.socksProxyHost.setEnabled(enabledState);
        this.socksProxyPort.setEnabled(enabledState);
    }

    public void clearGui() {
        super.clearGui();
        this.acceptInsecureCerts.setSelected(false);
        this.recreateBrowserOnIterationStart.setSelected(false);
        if (this.isBrowser()) {
            this.driverPath.setText("path to driver.exe of the relevant browser");
            this.devMode.setSelected(false);
        }
        if (!this.browserName().equals("HtmlUnit")) {
            if (!this.browserName().equals("internet explorer")) {
                this.headless.setSelected(false);
            }
            this.maximizeBrowser.setSelected(true);
        }
        if (this.browserName().equals("chrome") || this.browserName().equals("Remote")) {
            this.chromeAdditionalArgs.setText("");
            this.chromeBinaryPath.setText("");
        }
        if (this.browserName().equals("edge") || this.browserName().equals("Remote")) {
            this.edgeAdditionalArgs.setText("");
            this.edgeBinaryPath.setText("");
        }
        if (this.browserName().equals("firefox") || this.browserName().equals("Remote")) {
            this.userAgentOverrideCheckbox.setSelected(false);
            this.userAgentOverrideText.setText("");
            this.ntlmOverrideCheckbox.setSelected(false);
            this.extensions.getModel().clearData();
            this.preferences.getModel().clearData();
        }
        if (this.browserName().equals("internet explorer") || this.browserName().equals("Remote")) {
            this.fileUploadDialogTimeout.setText(String.valueOf(1000));
            this.ensureCleanSession.setSelected(false);
            this.ignoreProtectedMode.setSelected(false);
            this.silent.setSelected(false);
            this.initialBrowserUrl.setText("https://www.bing.com/");
        }
        this.clearProxy();
    }

    private void clearProxy() {
        this.systemProxy.setSelected(true);
        this.pacUrl.setText("");
        this.httpProxyHost.setText("");
        this.httpProxyPort.setText(String.valueOf(8080));
        this.useHttpSettingsForAllProtocols.setSelected(true);
        this.httpsProxyHost.setText("");
        this.httpsProxyPort.setText(String.valueOf(8080));
        this.ftpProxyHost.setText("");
        this.ftpProxyPort.setText(String.valueOf(8080));
        this.socksProxyHost.setText("");
        this.socksProxyPort.setText(String.valueOf(8080));
        this.noProxyList.setText(DEFAULT_NO_PROXY_LIST);
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof WebDriverConfig) {
            WebDriverConfig webDriverConfig = (WebDriverConfig)element;
            this.acceptInsecureCerts.setSelected(webDriverConfig.isAcceptInsecureCerts());
            this.recreateBrowserOnIterationStart.setSelected(webDriverConfig.isRecreateBrowserOnIterationStart());
            if (this.isBrowser()) {
                this.driverPath.setText(webDriverConfig.getDriverPath());
                this.devMode.setSelected(webDriverConfig.isDevMode());
            }
            if (!this.browserName().equals("HtmlUnit")) {
                if (!this.browserName().equals("internet explorer")) {
                    this.headless.setSelected(webDriverConfig.isHeadless());
                }
                this.maximizeBrowser.setSelected(webDriverConfig.isBrowserMaximized());
            }
            if (this.browserName().equals("chrome") || this.browserName().equals("Remote")) {
                this.chromeAdditionalArgs.setText(webDriverConfig.getChromeAdditionalArgs());
                this.chromeBinaryPath.setText(webDriverConfig.getChromeBinaryPath());
            }
            if (this.browserName().equals("edge") || this.browserName().equals("Remote")) {
                this.edgeAdditionalArgs.setText(webDriverConfig.getEdgeAdditionalArgs());
                this.edgeBinaryPath.setText(webDriverConfig.getEdgeBinaryPath());
            }
            if (this.browserName().equals("firefox") || this.browserName().equals("Remote")) {
                this.userAgentOverrideCheckbox.setSelected(webDriverConfig.isUserAgentOverridden());
                this.userAgentOverrideText.setText(webDriverConfig.getUserAgentOverride());
                this.userAgentOverrideText.setEnabled(webDriverConfig.isUserAgentOverridden());
                JMeterProperty ext = webDriverConfig.getExtensions();
                if (!(ext instanceof NullProperty)) {
                    JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)((CollectionProperty)ext), (PowerTableModel)this.extensions.getModel());
                }
                JMeterProperty pref = webDriverConfig.getPreferences();
                if (!(ext instanceof NullProperty)) {
                    JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)((CollectionProperty)pref), (PowerTableModel)this.preferences.getModel());
                }
            }
            if (this.browserName().equals("internet explorer") || this.browserName().equals("Remote")) {
                this.fileUploadDialogTimeout.setText(String.valueOf(webDriverConfig.getFileUploadDialogTimeout()));
                this.ensureCleanSession.setSelected(webDriverConfig.isEnsureCleanSession());
                this.ignoreProtectedMode.setSelected(webDriverConfig.isIgnoreProtectedMode());
                this.silent.setSelected(webDriverConfig.isSilent());
                this.initialBrowserUrl.setText(webDriverConfig.getInitialIeUrl());
            }
            this.configureProxy(webDriverConfig);
        }
    }

    private void configureProxy(WebDriverConfig<?> webDriverConfig) {
        switch (webDriverConfig.getProxyType()) {
            case DIRECT: {
                this.directProxy.setSelected(true);
                break;
            }
            case AUTO_DETECT: {
                this.autoDetectProxy.setSelected(true);
                break;
            }
            case MANUAL: {
                this.manualProxy.setSelected(true);
                break;
            }
            case PROXY_PAC: {
                this.pacUrlProxy.setSelected(true);
                break;
            }
            default: {
                this.systemProxy.setSelected(true);
            }
        }
        this.pacUrl.setText(webDriverConfig.getProxyPacUrl());
        this.httpProxyHost.setText(webDriverConfig.getHttpHost());
        this.httpProxyPort.setText(String.valueOf(webDriverConfig.getHttpPort()));
        this.useHttpSettingsForAllProtocols.setSelected(webDriverConfig.isUseHttpSettingsForAllProtocols());
        this.httpsProxyHost.setText(webDriverConfig.getHttpsHost());
        this.httpsProxyPort.setText(String.valueOf(webDriverConfig.getHttpsPort()));
        this.ftpProxyHost.setText(webDriverConfig.getFtpHost());
        this.ftpProxyPort.setText(String.valueOf(webDriverConfig.getFtpPort()));
        this.socksProxyHost.setText(webDriverConfig.getSocksHost());
        this.socksProxyPort.setText(String.valueOf(webDriverConfig.getSocksPort()));
        this.noProxyList.setText(webDriverConfig.getNoProxyHost());
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof WebDriverConfig) {
            WebDriverConfig webDriverConfig = (WebDriverConfig)element;
            webDriverConfig.setAcceptInsecureCerts(this.acceptInsecureCerts.isSelected());
            webDriverConfig.setRecreateBrowserOnIterationStart(this.recreateBrowserOnIterationStart.isSelected());
            if (this.isBrowser()) {
                webDriverConfig.setDriverPath(this.driverPath.getText());
                webDriverConfig.setDevMode(this.devMode.isSelected());
            }
            if (!this.browserName().equals("HtmlUnit")) {
                if (!this.browserName().equals("internet explorer")) {
                    webDriverConfig.setHeadless(this.headless.isSelected());
                }
                webDriverConfig.setBrowserMaximized(this.maximizeBrowser.isSelected());
            }
            if (this.browserName().equals("chrome") || this.browserName().equals("Remote")) {
                webDriverConfig.setChromeAdditionalArgs(this.chromeAdditionalArgs.getText());
                webDriverConfig.setChromeBinaryPath(this.chromeBinaryPath.getText());
            }
            if (this.browserName().equals("edge") || this.browserName().equals("Remote")) {
                webDriverConfig.setEdgeAdditionalArgs(this.edgeAdditionalArgs.getText());
                webDriverConfig.setEdgeBinaryPath(this.edgeBinaryPath.getText());
            }
            if (this.browserName().equals("firefox") || this.browserName().equals("Remote")) {
                webDriverConfig.setUserAgentOverridden(this.userAgentOverrideCheckbox.isSelected());
                webDriverConfig.setNtlmSetting(this.ntlmOverrideCheckbox.isSelected());
                if (this.userAgentOverrideCheckbox.isSelected()) {
                    webDriverConfig.setUserAgentOverride(this.userAgentOverrideText.getText());
                }
                webDriverConfig.setExtensions(this.extensions.getModel());
                webDriverConfig.setPreferences(this.preferences.getModel());
            }
            if (this.browserName().equals("internet explorer") || this.browserName().equals("Remote")) {
                webDriverConfig.setFileUploadDialogTimeout(Integer.parseInt(this.fileUploadDialogTimeout.getText()));
                webDriverConfig.setEnsureCleanSession(this.ensureCleanSession.isSelected());
                webDriverConfig.setIgnoreProtectedMode(this.ignoreProtectedMode.isSelected());
                webDriverConfig.setSilent(this.silent.isSelected());
                webDriverConfig.setInitialIeUrl(this.initialBrowserUrl.getText());
            }
            this.modifyProxy(webDriverConfig);
        }
    }

    private void modifyProxy(WebDriverConfig<?> webDriverConfig) {
        if (this.directProxy.isSelected()) {
            webDriverConfig.setProxyType(ProxyType.DIRECT);
        } else if (this.autoDetectProxy.isSelected()) {
            webDriverConfig.setProxyType(ProxyType.AUTO_DETECT);
        } else if (this.pacUrlProxy.isSelected()) {
            webDriverConfig.setProxyType(ProxyType.PROXY_PAC);
        } else if (this.manualProxy.isSelected()) {
            webDriverConfig.setProxyType(ProxyType.MANUAL);
        } else {
            webDriverConfig.setProxyType(ProxyType.SYSTEM);
        }
        webDriverConfig.setProxyPacUrl(this.pacUrl.getText());
        webDriverConfig.setHttpHost(this.httpProxyHost.getText());
        webDriverConfig.setHttpPort(Integer.parseInt(this.httpProxyPort.getText()));
        webDriverConfig.setUseHttpSettingsForAllProtocols(this.useHttpSettingsForAllProtocols.isSelected());
        webDriverConfig.setHttpsHost(this.httpsProxyHost.getText());
        webDriverConfig.setHttpsPort(Integer.parseInt(this.httpsProxyPort.getText()));
        webDriverConfig.setFtpHost(this.ftpProxyHost.getText());
        webDriverConfig.setFtpPort(Integer.parseInt(this.ftpProxyPort.getText()));
        webDriverConfig.setSocksHost(this.socksProxyHost.getText());
        webDriverConfig.setSocksPort(Integer.parseInt(this.socksProxyPort.getText()));
        webDriverConfig.setNoProxyHost(this.noProxyList.getText());
    }

    public boolean isValidUrl(String urlStr) {
        try {
            new URL(urlStr);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

