/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.sampler;

import org.apache.jmeter.samplers.SampleResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleResultWithSubs
extends SampleResult {
    private static final long serialVersionUID = 100L;
    private static final Logger log = LoggerFactory.getLogger(SampleResultWithSubs.class);
    private SampleResult subSample;

    public void subSampleStart(String label) {
        if (this.subSample != null) {
            log.warn("There is already a sub-sample started, continuing using it");
            return;
        }
        if (this.getStartTime() == 0L) {
            this.sampleStart();
        }
        this.subSample = new SampleResult();
        this.subSample.setSampleLabel(label);
        this.subSample.setDataType("text");
        this.subSample.setSuccessful(true);
        this.subSample.sampleStart();
    }

    public void subSampleEnd(boolean success) {
        if (this.subSample == null) {
            log.warn("There is no sub-sample started, use subSampleStart() to have one");
            return;
        }
        this.subSample.sampleEnd();
        this.subSample.setSuccessful(success);
        super.addSubResult(this.subSample);
        this.subSample = null;
    }

    public void sampleEnd() {
        if (this.subSample != null) {
            this.subSampleEnd(true);
        }
        if (this.getEndTime() == 0L) {
            super.sampleEnd();
        }
    }
}

