/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.sampler.gui;

import java.awt.Font;
import java.awt.HeadlessException;
import java.util.Properties;
import org.apache.jmeter.util.JMeterUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RUndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JSyntaxTextArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = 211L;
    private static final Logger log = LoggerFactory.getLogger(JSyntaxTextArea.class);
    private final Properties languageProperties = JMeterUtils.loadProperties((String)"org/apache/jmeter/gui/util/textarea.properties");
    private final boolean disableUndo;
    private static final boolean WRAP_STYLE_WORD = JMeterUtils.getPropDefault((String)"jsyntaxtextarea.wrapstyleword", (boolean)true);
    private static final boolean LINE_WRAP = JMeterUtils.getPropDefault((String)"jsyntaxtextarea.linewrap", (boolean)true);
    private static final boolean CODE_FOLDING = JMeterUtils.getPropDefault((String)"jsyntaxtextarea.codefolding", (boolean)true);
    private static final int MAX_UNDOS = JMeterUtils.getPropDefault((String)"jsyntaxtextarea.maxundos", (int)50);
    private static final String USER_FONT_FAMILY = JMeterUtils.getPropDefault((String)"jsyntaxtextarea.font.family", null);
    private static final int USER_FONT_SIZE = JMeterUtils.getPropDefault((String)"jsyntaxtextarea.font.size", (int)-1);

    public static JSyntaxTextArea getInstance(int rows, int cols, boolean disableUndo) {
        try {
            return new JSyntaxTextArea(rows, cols, disableUndo);
        }
        catch (HeadlessException e) {
            if ("true".equals(System.getProperty("java.awt.headless"))) {
                return new JSyntaxTextArea(disableUndo){
                    private static final long serialVersionUID = 1L;
                    private String text;

                    protected void init() {
                        try {
                            super.init();
                        }
                        catch (HeadlessException | NullPointerException runtimeException) {
                            // empty catch block
                        }
                    }

                    public void setCodeFoldingEnabled(boolean b) {
                    }

                    public void setCaretPosition(int b) {
                    }

                    public void discardAllEdits() {
                    }

                    public void setText(String t) {
                        this.text = t;
                    }

                    public String getText() {
                        return this.text;
                    }

                    public boolean isCodeFoldingEnabled() {
                        return true;
                    }
                };
            }
            throw e;
        }
    }

    public static JSyntaxTextArea getInstance(int rows, int cols) {
        return JSyntaxTextArea.getInstance(rows, cols, false);
    }

    @Deprecated
    public JSyntaxTextArea() {
        this(30, 50, false);
    }

    private JSyntaxTextArea(boolean dummy) {
        this.disableUndo = dummy;
    }

    @Deprecated
    public JSyntaxTextArea(int rows, int cols) {
        this(rows, cols, false);
    }

    @Deprecated
    public JSyntaxTextArea(int rows, int cols, boolean disableUndo) {
        super(rows, cols);
        super.setSyntaxEditingStyle("text/java");
        super.setCodeFoldingEnabled(CODE_FOLDING);
        super.setAntiAliasingEnabled(true);
        super.setLineWrap(LINE_WRAP);
        super.setWrapStyleWord(WRAP_STYLE_WORD);
        this.disableUndo = disableUndo;
        if (USER_FONT_FAMILY != null) {
            int fontSize = USER_FONT_SIZE > 0 ? USER_FONT_SIZE : this.getFont().getSize();
            this.setFont(new Font(USER_FONT_FAMILY, 0, fontSize));
            if (log.isDebugEnabled()) {
                log.debug("Font is set to: {}", (Object)this.getFont());
            }
        }
        if (disableUndo) {
            this.discardAllEdits();
        }
    }

    public void setLanguage(String language) {
        if (language == null) {
            super.setSyntaxEditingStyle("text/plain");
        } else {
            String style = this.languageProperties.getProperty(language);
            if (style == null) {
                super.setSyntaxEditingStyle("text/plain");
            } else {
                super.setSyntaxEditingStyle(style);
            }
        }
    }

    protected RUndoManager createUndoManager() {
        RUndoManager undoManager = super.createUndoManager();
        if (this.disableUndo) {
            undoManager.setLimit(0);
        } else {
            undoManager.setLimit(MAX_UNDOS);
        }
        return undoManager;
    }

    public void setInitialText(String string) {
        this.setText(string);
        this.discardAllEdits();
    }
}

