/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.jmeter.functions;

import io.metersphere.jmeter.utils.ScriptEngineUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class MockFunction
extends AbstractFunction {
    public static final String KEY = "__Mock";
    private static final List<String> desc = new LinkedList<String>();
    private CompoundVariable varName;

    public String execute(SampleResult previousResult, Sampler currentSampler) {
        String value = "";
        if (this.varName != null) {
            JMeterVariables vars = this.getVariables();
            String varTrim = this.varName.execute().trim();
            if (vars != null && varTrim.length() > 0) {
                value = ScriptEngineUtils.calculate(varTrim);
                vars.put(varTrim, value);
            }
        }
        return value;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 1);
        Object[] values = parameters.toArray();
        this.varName = (CompoundVariable)values[0];
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add("String to calculate Mock");
    }
}

