/*
 * Decompiled with CFR 0.152.
 */
package io.metersphere.jmeter.utils;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class ScriptEngineUtils {
    private static ScriptEngine engine;

    public static String buildFunctionCallString(String input) {
        if (!StringUtils.startsWith((CharSequence)input, (CharSequence)"@")) {
            return input;
        }
        return "${__Mock(" + RegExUtils.replaceAll((String)input, (String)",", (String)"\\\\,") + ")}";
    }

    public static String calculate(String input) {
        try {
            return engine.eval("calculate('" + input + "')").toString();
        }
        catch (ScriptException e) {
            e.printStackTrace();
            return input;
        }
    }

    public static void init() {
        try {
            RhinoScriptEngineFactory rhinoScriptEngineFactory = new RhinoScriptEngineFactory();
            engine = rhinoScriptEngineFactory.getScriptEngine();
            String scriptString = IOUtils.toString((URL)ScriptEngineUtils.class.getResource("/javascript/func.js"), (Charset)StandardCharsets.UTF_8);
            engine.eval(scriptString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        ScriptEngineUtils.init();
    }
}

