/*
 * Decompiled with CFR 0.152.
 */
package io.michaelrocks.libphonenumber.android.metadata.source;

import io.michaelrocks.libphonenumber.android.Phonemetadata;
import io.michaelrocks.libphonenumber.android.internal.GeoEntityUtility;
import io.michaelrocks.libphonenumber.android.metadata.source.MapBackedMetadataContainer;
import io.michaelrocks.libphonenumber.android.metadata.source.MetadataContainer;

final class CompositeMetadataContainer
implements MetadataContainer {
    private final MapBackedMetadataContainer<Integer> metadataByCountryCode = MapBackedMetadataContainer.byCountryCallingCode();
    private final MapBackedMetadataContainer<String> metadataByRegionCode = MapBackedMetadataContainer.byRegionCode();

    CompositeMetadataContainer() {
    }

    Phonemetadata.PhoneMetadata getMetadataBy(String regionCode) {
        return this.metadataByRegionCode.getMetadataBy(regionCode);
    }

    Phonemetadata.PhoneMetadata getMetadataBy(int countryCallingCode) {
        return this.metadataByCountryCode.getMetadataBy(countryCallingCode);
    }

    @Override
    public void accept(Phonemetadata.PhoneMetadata phoneMetadata) {
        String regionCode = this.metadataByRegionCode.getKeyProvider().getKeyOf(phoneMetadata);
        if (GeoEntityUtility.isGeoEntity(regionCode)) {
            this.metadataByRegionCode.accept(phoneMetadata);
        } else {
            this.metadataByCountryCode.accept(phoneMetadata);
        }
    }
}

