/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;

public class CacheProxy
implements InvocationHandler {
    private final ConcurrentMap<Key, Object> cache = new ConcurrentHashMap<Key, Object>(256);
    private final Object delegate;

    public static <T> T cache(T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), delegate.getClass().getInterfaces(), (InvocationHandler)new CacheProxy(delegate));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        return this.cache.computeIfAbsent(new Key(method, args), k -> {
            try {
                return method.invoke(this.delegate, ((Key)k).args);
            }
            catch (Exception e) {
                this.handleExceptionCause(e);
                throw new RuntimeException(e);
            }
        });
    }

    private void handleExceptionCause(Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new RuntimeException(cause);
    }

    @ConstructorProperties(value={"delegate"})
    @Generated
    public CacheProxy(Object delegate) {
        this.delegate = delegate;
    }

    private static final class Key {
        private final Method method;
        private final Object[] args;

        @ConstructorProperties(value={"method", "args"})
        @Generated
        public Key(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Generated
        public Object[] getArgs() {
            return this.args;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            return Arrays.deepEquals(this.getArgs(), other.getArgs());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            return result;
        }

        @Generated
        public String toString() {
            return "CacheProxy.Key(method=" + this.getMethod() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
        }
    }
}

