/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.Logger;
import io.microconfig.utils.Os;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;

public class FileUtils {
    public static final String LINES_SEPARATOR = System.lineSeparator();

    public static void copyPermissions(Path from, Path to) {
        if (Os.isWindows()) {
            return;
        }
        try {
            Files.setPosixFilePermissions(to, Files.getPosixFilePermissions(from, new LinkOption[0]));
        }
        catch (IOException e) {
            Logger.error(String.format("Cannot copy file permissions from %s to %s", from, to), e);
        }
    }

    public static void write(File file, String content) {
        FileUtils.write(file.toPath(), content, new OpenOption[0]);
    }

    public static void write(Path file, String content, OpenOption ... options) {
        FileUtils.write(file, content.getBytes(), options);
    }

    public static void write(Path file, byte[] content, OpenOption ... options) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, content, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void delete(File ... paths) {
        Arrays.stream(paths).forEach(FileUtils::delete);
    }

    public static void delete(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            if (!path.delete()) {
                Logger.warn("Can't delete file " + path);
            }
        } else if (!FileUtils.deleteDir(path)) {
            Logger.warn("Can't delete dir " + path);
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            Stream.of(dir.listFiles()).forEach(FileUtils::deleteDir);
        }
        return dir.delete();
    }

    public static File canonical(File repoDir) {
        try {
            return repoDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Path> walk(Path path) {
        try {
            return Files.walk(path, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getExtension(File file) {
        int extIndex = FileUtils.extensionIndex(file);
        return extIndex < 0 ? "" : file.getName().substring(extIndex);
    }

    public static String getName(File file) {
        int extIndex = FileUtils.extensionIndex(file);
        return extIndex < 0 ? file.getName() : file.getName().substring(0, extIndex);
    }

    private static int extensionIndex(File file) {
        return file.getName().lastIndexOf(46);
    }

    @Generated
    private FileUtils() {
    }
}

