/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class IoUtils {
    public static String readFully(File file) {
        try {
            return IoUtils.readFully(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readAllBytes(File file) {
        try {
            return IoUtils.readAllBytes(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readClasspathResource(String file) {
        return IoUtils.readFully(IoUtils.class.getClassLoader().getResourceAsStream(file));
    }

    public static String readFully(InputStream is) {
        return IoUtils.doRead(is).toString();
    }

    public static byte[] readAllBytes(InputStream is) {
        return IoUtils.doRead(is).toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ByteArrayOutputStream doRead(InputStream is) {
        try (InputStream input = is;){
            int n;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            ByteArrayOutputStream byteArrayOutputStream = output;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readLines(File file) {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    private IoUtils() {
    }
}

