/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.utils;

import io.microconfig.utils.ConsoleColor;
import java.io.PrintWriter;
import java.io.StringWriter;
import lombok.Generated;

public class Logger {
    private static volatile boolean enabled = true;
    private static volatile boolean errorOccurred;

    public static void error(Throwable e) {
        if (e != null) {
            Logger.error(null, e);
        }
    }

    public static void error(String message, Throwable e) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        if (message != null) {
            writer.println(message);
        }
        if (e != null) {
            e.printStackTrace(writer);
        }
        Logger.error(out.toString());
    }

    public static void warn(String message) {
        Logger.info(ConsoleColor.yellow(message));
    }

    public static void announce(String message) {
        Logger.info(ConsoleColor.green(message));
    }

    public static void info(String message) {
        if (!enabled) {
            return;
        }
        System.out.println(message);
    }

    public static void error(String message) {
        errorOccurred = true;
        System.out.println(ConsoleColor.red(message));
    }

    public static boolean isErrorOccurred() {
        return errorOccurred;
    }

    public static void enableLogger(boolean enabled) {
        Logger.enabled = enabled;
    }

    @Generated
    private Logger() {
    }
}

