/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractMeterRegistry
implements MeterRegistry {
    protected final Clock clock;
    private final List<Tag> commonTags = new ArrayList<Tag>();
    private final ConcurrentMap<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();
    private NamingConvention namingConvention = NamingConvention.snakeCase;
    private MeterRegistry.Config config = new MeterRegistry.Config(){

        @Override
        public MeterRegistry.Config commonTags(Iterable<Tag> tags) {
            StreamSupport.stream(tags.spliterator(), false).map(t -> Tag.of(AbstractMeterRegistry.this.namingConvention.tagKey(t.getKey()), AbstractMeterRegistry.this.namingConvention.tagValue(t.getValue()))).forEach(AbstractMeterRegistry.this.commonTags::add);
            return this;
        }

        @Override
        public MeterRegistry.Config namingConvention(NamingConvention convention) {
            AbstractMeterRegistry.this.namingConvention = convention;
            return this;
        }

        @Override
        public Clock clock() {
            return AbstractMeterRegistry.this.clock;
        }
    };
    private MeterRegistry.More more = new MeterRegistry.More(){

        @Override
        public LongTaskTimer.Builder longTaskTimerBuilder(String name) {
            return new LongTaskTimerBuilder(name);
        }

        @Override
        public <T> T counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
            WeakReference ref = new WeakReference(obj);
            AbstractMeterRegistry.this.register(name, tags, Meter.Type.Counter, Collections.singletonList(new Measurement(() -> {
                Object obj2 = ref.get();
                return obj2 != null ? f.applyAsDouble(obj2) : 0.0;
            }, Statistic.Count)));
            return obj;
        }
    };

    @Override
    public MeterRegistry.Config config() {
        return this.config;
    }

    public AbstractMeterRegistry(Clock clock) {
        this.clock = clock;
    }

    protected abstract DistributionSummary newDistributionSummary(String var1, Iterable<Tag> var2, String var3, Quantiles var4, Histogram<?> var5);

    protected abstract <T> Gauge newGauge(String var1, Iterable<Tag> var2, String var3, ToDoubleFunction<T> var4, T var5);

    protected abstract Counter newCounter(String var1, Iterable<Tag> var2, String var3);

    protected abstract LongTaskTimer newLongTaskTimer(String var1, Iterable<Tag> var2, String var3);

    protected abstract Timer newTimer(String var1, Iterable<Tag> var2, String var3, Histogram<?> var4, Quantiles var5);

    protected abstract void newMeter(String var1, Iterable<Tag> var2, Meter.Type var3, Iterable<Measurement> var4);

    @Override
    public MeterRegistry register(String name, Iterable<Tag> tags, Meter.Type type, Iterable<Measurement> measurements) {
        this.meterMap.computeIfAbsent(new MeterId(name, tags), id -> {
            this.newMeter(id.getConventionName(type), id.getTags(), type, measurements);
            return new Meter((MeterId)id, measurements){
                final /* synthetic */ MeterId val$id;
                final /* synthetic */ Iterable val$measurements;
                {
                    this.val$id = meterId;
                    this.val$measurements = iterable;
                }

                @Override
                public String getName() {
                    return this.val$id.getName();
                }

                @Override
                public Iterable<Tag> getTags() {
                    return this.val$id.getTags();
                }

                @Override
                public String getDescription() {
                    return null;
                }

                @Override
                public Iterable<Measurement> measure() {
                    return this.val$measurements;
                }
            };
        });
        return this;
    }

    @Override
    public final <T> Gauge.Builder gaugeBuilder(String name, T obj, ToDoubleFunction<T> f) {
        return new GaugeBuilder(name, obj, f);
    }

    @Override
    public Timer.Builder timerBuilder(String name) {
        return new TimerBuilder(name);
    }

    @Override
    public DistributionSummary.Builder summaryBuilder(String name) {
        return new DistributionSummaryBuilder(name);
    }

    @Override
    public Counter.Builder counterBuilder(String name) {
        return new CounterBuilder(name);
    }

    @Override
    public MeterRegistry.More more() {
        return this.more;
    }

    @Override
    public MeterRegistry.Search find(String name) {
        return new SearchImpl(name);
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterType, String name, Iterable<Tag> tags, Function<MeterId, Meter> builder) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must be non-empty");
        }
        ConcurrentMap<MeterId, Meter> concurrentMap = this.meterMap;
        synchronized (concurrentMap) {
            Meter m = this.meterMap.computeIfAbsent(new MeterId(name, tags), builder);
            if (!meterType.isInstance(m)) {
                throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
            }
            return (M)m;
        }
    }

    class MeterId {
        private final String name;
        private final Iterable<Tag> tags;

        MeterId(String name, Iterable<Tag> tags) {
            this.name = name;
            this.tags = tags;
        }

        String getName() {
            return this.name;
        }

        String getConventionName(Meter.Type type, String baseUnit) {
            return AbstractMeterRegistry.this.namingConvention.name(this.name, type, baseUnit);
        }

        String getConventionName(Meter.Type type) {
            return this.getConventionName(type, null);
        }

        public List<Tag> getTags() {
            Stream<Tag> formattedTags = StreamSupport.stream(this.tags.spliterator(), false).map(t -> Tag.of(AbstractMeterRegistry.this.namingConvention.tagKey(t.getKey()), AbstractMeterRegistry.this.namingConvention.tagValue(t.getValue())));
            return Stream.concat(formattedTags, AbstractMeterRegistry.this.commonTags.stream()).sorted(Comparator.comparing(Tag::getKey)).collect(Collectors.toList());
        }

        public String toString() {
            return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MeterId meterId = (MeterId)o;
            return (this.name != null ? this.name.equals(meterId.name) : meterId.name == null) && (this.tags != null ? this.tags.equals(meterId.tags) : meterId.tags == null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }

    private class SearchImpl
    implements MeterRegistry.Search {
        private final String name;
        private List<Tag> tags = new ArrayList<Tag>();
        private Map<Statistic, Double> valueAsserts = new HashMap<Statistic, Double>();

        SearchImpl(String name) {
            this.name = name;
        }

        @Override
        public MeterRegistry.Search tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public MeterRegistry.Search value(Statistic statistic, double value) {
            this.valueAsserts.put(statistic, value);
            return this;
        }

        @Override
        public Optional<Timer> timer() {
            return this.meters().stream().filter(m -> m instanceof Timer).findAny().map(Timer.class::cast);
        }

        @Override
        public Optional<Counter> counter() {
            return this.meters().stream().filter(m -> m instanceof Counter).findAny().map(Counter.class::cast);
        }

        @Override
        public Optional<Gauge> gauge() {
            return this.meters().stream().filter(m -> m instanceof Gauge).findAny().map(Gauge.class::cast);
        }

        @Override
        public Optional<DistributionSummary> summary() {
            return this.meters().stream().filter(m -> m instanceof DistributionSummary).findAny().map(DistributionSummary.class::cast);
        }

        @Override
        public Optional<LongTaskTimer> longTaskTimer() {
            return this.meters().stream().filter(m -> m instanceof LongTaskTimer).findAny().map(LongTaskTimer.class::cast);
        }

        @Override
        public Optional<Meter> meter() {
            MeterId id = new MeterId(this.name, this.tags);
            return AbstractMeterRegistry.this.meterMap.keySet().stream().filter(id2 -> id2.getName().equals(id.getName())).filter(id2 -> id2.getTags().containsAll(id.getTags())).map(AbstractMeterRegistry.this.meterMap::get).filter(m -> {
                for (Measurement measurement : m.measure()) {
                    if (this.valueAsserts.getOrDefault((Object)measurement.getStatistic(), measurement.getValue()).doubleValue() == measurement.getValue()) continue;
                    return false;
                }
                return true;
            }).findAny();
        }

        @Override
        public Collection<Meter> meters() {
            MeterId id = new MeterId(this.name, this.tags);
            return AbstractMeterRegistry.this.meterMap.keySet().stream().filter(id2 -> id2.getName().equals(id.getName())).filter(id2 -> id2.getTags().containsAll(id.getTags())).map(AbstractMeterRegistry.this.meterMap::get).collect(Collectors.toList());
        }
    }

    private class LongTaskTimerBuilder
    implements LongTaskTimer.Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;

        private LongTaskTimerBuilder(String name) {
            this.name = name;
        }

        @Override
        public LongTaskTimer.Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public LongTaskTimer.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public LongTaskTimer create() {
            return (LongTaskTimer)AbstractMeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, this.name, this.tags, id -> AbstractMeterRegistry.this.newLongTaskTimer(id.getConventionName(Meter.Type.LongTaskTimer), id.getTags(), this.description));
        }
    }

    private class CounterBuilder
    implements Counter.Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;

        private CounterBuilder(String name) {
            this.name = name;
        }

        @Override
        public Counter.Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public Counter.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Counter create() {
            return (Counter)AbstractMeterRegistry.this.registerMeterIfNecessary(Counter.class, this.name, this.tags, id -> AbstractMeterRegistry.this.newCounter(id.getConventionName(Meter.Type.Counter), id.getTags(), this.description));
        }
    }

    private class DistributionSummaryBuilder
    implements DistributionSummary.Builder {
        private final String name;
        private Quantiles quantiles;
        private Histogram<?> histogram;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;
        private String baseUnit;

        private DistributionSummaryBuilder(String name) {
            this.name = name;
        }

        @Override
        public DistributionSummary.Builder quantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        @Override
        public DistributionSummary.Builder histogram(Histogram<?> histogram) {
            this.histogram = histogram;
            return this;
        }

        @Override
        public DistributionSummary.Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public DistributionSummary.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public DistributionSummary.Builder baseUnit(String unit) {
            this.baseUnit = unit;
            return this;
        }

        @Override
        public DistributionSummary create() {
            return (DistributionSummary)AbstractMeterRegistry.this.registerMeterIfNecessary(DistributionSummary.class, this.name, this.tags, id -> AbstractMeterRegistry.this.newDistributionSummary(id.getConventionName(Meter.Type.DistributionSummary, this.baseUnit), id.getTags(), this.description, this.quantiles, this.histogram));
        }
    }

    private class TimerBuilder
    implements Timer.Builder {
        private final String name;
        private Quantiles quantiles;
        private Histogram<?> histogram;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;

        private TimerBuilder(String name) {
            this.name = name;
        }

        @Override
        public Timer.Builder quantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public Timer.Builder histogram(Histogram histogram) {
            this.histogram = histogram;
            return this;
        }

        @Override
        public Timer.Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public Timer.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Timer create() {
            return (Timer)AbstractMeterRegistry.this.registerMeterIfNecessary(Timer.class, this.name, this.tags, id -> AbstractMeterRegistry.this.newTimer(id.getConventionName(Meter.Type.Timer), id.getTags(), this.description, this.histogram, this.quantiles));
        }
    }

    private class GaugeBuilder<T>
    implements Gauge.Builder {
        private final String name;
        private final T obj;
        private final ToDoubleFunction<T> f;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String description;

        private GaugeBuilder(String name, T obj, ToDoubleFunction<T> f) {
            this.name = name;
            this.obj = obj;
            this.f = f;
        }

        @Override
        public Gauge.Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public Gauge.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Gauge create() {
            return (Gauge)AbstractMeterRegistry.this.registerMeterIfNecessary(Gauge.class, this.name, this.tags, id -> AbstractMeterRegistry.this.newGauge(id.getConventionName(Meter.Type.Gauge), id.getTags(), this.description, this.f, this.obj));
        }
    }
}

