/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Arrays;

public interface DistributionSummary
extends Meter {
    public void record(double var1);

    public long count();

    public double totalAmount();

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(this::totalAmount, Statistic.Total));
    }

    public static interface Builder {
        public Builder quantiles(Quantiles var1);

        public Builder histogram(Histogram<?> var1);

        public Builder tags(Iterable<Tag> var1);

        default public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder description(String var1);

        public Builder baseUnit(String var1);

        public DistributionSummary create();
    }
}

