/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface LongTaskTimer
extends Meter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordCallable(Callable<T> f) throws Exception {
        long id = this.start();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T record(Supplier<T> f) throws Exception {
        long id = this.start();
        try {
            T t = f.get();
            return t;
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void record(Consumer<Long> f) {
        long id = this.start();
        try {
            f.accept(id);
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void record(Runnable f) {
        long id = this.start();
        try {
            f.run();
        }
        finally {
            this.stop(id);
        }
    }

    public long start();

    public long stop(long var1);

    public long duration(long var1);

    public long duration();

    public int activeTasks();

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.activeTasks(), Statistic.Count), new Measurement(() -> this.duration(), Statistic.Total));
    }

    @Override
    default public Meter.Type getType() {
        return Meter.Type.LongTaskTimer;
    }

    public static interface Builder {
        public Builder tags(Iterable<Tag> var1);

        default public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder description(String var1);

        public LongTaskTimer create();
    }
}

