/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;

public interface MeterRegistry {
    public Collection<Meter> getMeters();

    public Config config();

    public Search find(String var1);

    public Counter.Builder counterBuilder(String var1);

    default public Counter counter(String name, Iterable<Tag> tags) {
        return this.counterBuilder(name).tags(tags).create();
    }

    default public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.zip(tags));
    }

    public DistributionSummary.Builder summaryBuilder(String var1);

    default public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return this.summaryBuilder(name).tags(tags).create();
    }

    default public DistributionSummary summary(String name, String ... tags) {
        return this.summary(name, Tags.zip(tags));
    }

    public Timer.Builder timerBuilder(String var1);

    default public Timer timer(String name, Iterable<Tag> tags) {
        return this.timerBuilder(name).tags(tags).create();
    }

    default public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.zip(tags));
    }

    public More more();

    public MeterRegistry register(String var1, Iterable<Tag> var2, Meter.Type var3, Iterable<Measurement> var4);

    default public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        this.gaugeBuilder(name, obj, f).tags(tags).create();
        return obj;
    }

    default public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    default public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    default public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, Collections.emptyList(), obj, f);
    }

    default public <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    default public <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)this.gauge(name, tags, map, Map::size);
    }

    public <T> Gauge.Builder gaugeBuilder(String var1, T var2, ToDoubleFunction<T> var3);

    public static interface More {
        default public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
            return this.longTaskTimerBuilder(name).tags(tags).create();
        }

        default public LongTaskTimer longTaskTimer(String name, String ... tags) {
            return this.longTaskTimer(name, Tags.zip(tags));
        }

        public LongTaskTimer.Builder longTaskTimerBuilder(String var1);

        public <T> T counter(String var1, Iterable<Tag> var2, T var3, ToDoubleFunction<T> var4);

        default public <T extends Number> T counter(String name, Iterable<Tag> tags, T number) {
            return (T)this.counter(name, tags, number, Number::doubleValue);
        }
    }

    public static interface Search {
        default public Search tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Search tags(Iterable<Tag> var1);

        public Search value(Statistic var1, double var2);

        public Optional<Timer> timer();

        public Optional<Counter> counter();

        public Optional<Gauge> gauge();

        public Optional<DistributionSummary> summary();

        public Optional<LongTaskTimer> longTaskTimer();

        public Optional<Meter> meter();

        public Collection<Meter> meters();
    }

    public static interface Config {
        public Config commonTags(Iterable<Tag> var1);

        default public Config commonTags(String ... tags) {
            this.commonTags(Tags.zip(tags));
            return this;
        }

        public Config namingConvention(NamingConvention var1);

        public Clock clock();
    }
}

