/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter {
    public void record(long var1, TimeUnit var3);

    public <T> T record(Supplier<T> var1);

    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    default public Runnable wrap(Runnable f) {
        return () -> this.record(f);
    }

    public <T> Callable<T> wrap(Callable<T> var1);

    public long count();

    public double totalTime(TimeUnit var1);

    default public double totalTimeNanos() {
        return this.totalTime(TimeUnit.NANOSECONDS);
    }

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.Count), new Measurement(this::totalTimeNanos, Statistic.Total));
    }

    @Override
    default public Meter.Type getType() {
        return Meter.Type.Timer;
    }

    public static interface Builder {
        public Builder quantiles(Quantiles var1);

        public Builder histogram(Histogram<?> var1);

        public Builder tags(Iterable<Tag> var1);

        default public Builder tags(String ... tags) {
            return this.tags(Tags.zip(tags));
        }

        public Builder description(String var1);

        public Timer create();
    }
}

