/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;

public class CaffeineCacheMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final Cache<?, ?> cache;

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends Cache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        new CaffeineCacheMetrics(name, tags, cache).bindTo(registry);
        return cache;
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String name, String ... tags) {
        return CaffeineCacheMetrics.monitor(registry, cache, name, Tags.zip(tags));
    }

    public static <C extends AsyncLoadingCache> C monitor(MeterRegistry registry, C cache, String name, Iterable<Tag> tags) {
        CaffeineCacheMetrics.monitor(registry, cache.synchronous(), name, tags);
        return cache;
    }

    public CaffeineCacheMetrics(String name, Iterable<Tag> tags, Cache<?, ?> cache) {
        this.name = name;
        this.tags = tags;
        this.cache = cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge(this.name + ".estimated.size", this.tags, this.cache, Cache::estimatedSize);
        registry.more().counter(this.name + ".requests", Tags.zip("result", "miss"), this.cache, c -> c.stats().missCount());
        registry.more().counter(this.name + ".requests", Tags.zip("result", "hit"), this.cache, c -> c.stats().hitCount());
        registry.more().counter(this.name + ".evictions", this.tags, this.cache, c -> c.stats().evictionCount());
        registry.gauge(this.name + ".eviction.weight", this.tags, this.cache, c -> c.stats().evictionWeight());
        if (this.cache instanceof LoadingCache) {
            registry.more().counter(this.name + ".load.duration", this.tags, this.cache, c -> c.stats().totalLoadTime());
            registry.more().counter(this.name + ".load", Tags.concat(this.tags, "result", "success"), this.cache, c -> c.stats().loadSuccessCount());
            registry.more().counter(this.name + ".load", Tags.concat(this.tags, "result", "failure"), this.cache, c -> c.stats().loadFailureCount());
        }
    }
}

