/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.internal.TimedExecutorService;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecutorServiceMetrics
implements MeterBinder {
    private final ExecutorService executorService;
    private final String name;
    private final Iterable<Tag> tags;

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Iterable<Tag> tags) {
        Timer commandTimer = registry.timer(name, tags);
        return commandTimer::record;
    }

    public static Executor monitor(MeterRegistry registry, Executor executor, String name, Tag ... tags) {
        return ExecutorServiceMetrics.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Iterable<Tag> tags) {
        new ExecutorServiceMetrics(executor, name, tags).bindTo(registry);
        return new TimedExecutorService(registry, executor, name, tags);
    }

    public static ExecutorService monitor(MeterRegistry registry, ExecutorService executor, String name, Tag ... tags) {
        return ExecutorServiceMetrics.monitor(registry, executor, name, Arrays.asList(tags));
    }

    public ExecutorServiceMetrics(ExecutorService executorService, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.executorService = executorService;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (this.executorService == null) {
            return;
        }
        String className = this.executorService.getClass().getName();
        if (this.executorService instanceof ThreadPoolExecutor) {
            this.monitor(registry, (ThreadPoolExecutor)this.executorService);
        } else if (className.equals("java.util.concurrent.Executors$DelegatedScheduledExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass()));
        } else if (className.equals("java.util.concurrent.Executors$FinalizableDelegatedExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass().getSuperclass()));
        } else if (this.executorService instanceof ForkJoinPool) {
            this.monitor(registry, (ForkJoinPool)this.executorService);
        }
    }

    private ThreadPoolExecutor unwrapThreadPoolExecutor(ExecutorService executor, Class<?> wrapper) {
        try {
            Field e = wrapper.getDeclaredField("e");
            e.setAccessible(true);
            return (ThreadPoolExecutor)e.get(this.executorService);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    private void monitor(MeterRegistry registry, ThreadPoolExecutor tp) {
        if (tp == null) {
            return;
        }
        registry.more().counter(this.name + ".tasks", Collections.emptyList(), tp, tpRef -> tpRef.getTaskCount() + tpRef.getCompletedTaskCount() + (long)tpRef.getActiveCount());
        registry.more().counter(this.name + ".completed", Collections.emptyList(), tp, ThreadPoolExecutor::getCompletedTaskCount);
        registry.gauge(this.name + ".active", tp, ThreadPoolExecutor::getActiveCount);
        registry.gauge(this.name + ".queue.size", this.tags, tp, tpRef -> tpRef.getQueue().size());
        registry.gauge(this.name + ".pool.size", this.tags, tp, ThreadPoolExecutor::getPoolSize);
    }

    private void monitor(MeterRegistry registry, ForkJoinPool fj) {
        registry.more().counter(this.name + ".steal.count", Collections.emptyList(), fj, ForkJoinPool::getStealCount);
        registry.gauge(this.name + ".queued.tasks", fj, ForkJoinPool::getQueuedTaskCount);
        registry.gauge(this.name + ".active", fj, ForkJoinPool::getActiveThreadCount);
        registry.gauge(this.name + ".running.threads", fj, ForkJoinPool::getRunningThreadCount);
    }
}

