/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Collections;
import java.util.List;

public class JvmMemoryMetrics
implements MeterBinder {
    @Override
    public void bindTo(MeterRegistry registry) {
        List<Tag> tags;
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            tags = Collections.singletonList(Tag.of("id", bufferPoolBean.getName()));
            registry.gauge("jvm.buffer.count", tags, bufferPoolBean, BufferPoolMXBean::getCount);
            registry.gauge("jvm.buffer.memory.used", tags, bufferPoolBean, BufferPoolMXBean::getMemoryUsed);
            registry.gauge("jvm.buffer.total.capacity", tags, bufferPoolBean, BufferPoolMXBean::getTotalCapacity);
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            tags = Collections.singletonList(Tag.of("id", memoryPoolBean.getName()));
            registry.gauge("jvm.memory.used", tags, memoryPoolBean, mem -> mem.getUsage().getUsed());
            registry.gauge("jvm.memory.committed", tags, memoryPoolBean, mem -> mem.getUsage().getCommitted());
            registry.gauge("jvm.memory.max", tags, memoryPoolBean, mem -> mem.getUsage().getMax());
        }
    }
}

