/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopGauge;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.ToDoubleFunction;

public class CompositeGauge<T>
extends AbstractMeter
implements Gauge,
CompositeMeter {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;
    private final Map<MeterRegistry, Gauge> gauges = Collections.synchronizedMap(new LinkedHashMap());

    CompositeGauge(String name, Iterable<Tag> tags, String description, T obj, ToDoubleFunction<T> f) {
        super(name, tags, description);
        this.ref = new WeakReference<T>(obj);
        this.f = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double value() {
        Map<MeterRegistry, Gauge> map = this.gauges;
        synchronized (map) {
            return this.gauges.values().stream().findFirst().orElse(NoopGauge.INSTANCE).value();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj != null) {
            Map<MeterRegistry, Gauge> map = this.gauges;
            synchronized (map) {
                this.gauges.put(registry, registry.gaugeBuilder(this.getName(), obj, this.f).tags(this.getTags()).create());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, Gauge> map = this.gauges;
        synchronized (map) {
            this.gauges.remove(registry);
        }
    }
}

