/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompositeLongTaskTimer
extends AbstractMeter
implements LongTaskTimer,
CompositeMeter {
    private final Map<MeterRegistry, LongTaskTimer> timers = Collections.synchronizedMap(new LinkedHashMap());

    CompositeLongTaskTimer(String name, Iterable<Tag> tags, String description) {
        super(name, tags, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start() {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(LongTaskTimer::start).reduce((t1, t2) -> t2).orElse(NoopLongTaskTimer.INSTANCE.start());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long stop(long task) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(ltt -> ltt.stop(task)).reduce((t1, t2) -> t2 == -1L ? t1 : t2).orElse(NoopLongTaskTimer.INSTANCE.stop(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long duration(long task) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(ltt -> ltt.duration(task)).reduce((t1, t2) -> t2 == -1L ? t1 : t2).orElse(NoopLongTaskTimer.INSTANCE.duration(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long duration() {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(LongTaskTimer::duration).reduce((t1, t2) -> t2).orElse(NoopLongTaskTimer.INSTANCE.duration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int activeTasks() {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().map(LongTaskTimer::activeTasks).reduce((t1, t2) -> t2).orElse(NoopLongTaskTimer.INSTANCE.activeTasks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            this.timers.put(registry, registry.more().longTaskTimer(this.getName(), this.getTags()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, LongTaskTimer> map = this.timers;
        synchronized (map) {
            this.timers.remove(registry);
        }
    }
}

