/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeCounter;
import io.micrometer.core.instrument.composite.CompositeCustomMeter;
import io.micrometer.core.instrument.composite.CompositeDistributionSummary;
import io.micrometer.core.instrument.composite.CompositeGauge;
import io.micrometer.core.instrument.composite.CompositeLongTaskTimer;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.composite.CompositeTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.ToDoubleFunction;

public class CompositeMeterRegistry
extends AbstractMeterRegistry {
    private final Set<MeterRegistry> registries = ConcurrentHashMap.newKeySet();
    private Collection<CompositeMeter> compositeMeters = new CopyOnWriteArrayList<CompositeMeter>();

    public CompositeMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public CompositeMeterRegistry(Clock clock) {
        super(clock);
    }

    @Override
    protected Timer newTimer(String name, Iterable<Tag> tags, String description, Histogram<?> histogram, Quantiles quantiles) {
        CompositeTimer timer = new CompositeTimer(name, tags, description, quantiles, histogram, this.clock);
        this.compositeMeters.add(timer);
        this.registries.forEach(timer::add);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(String name, Iterable<Tag> tags, String description, Quantiles quantiles, Histogram<?> histogram) {
        CompositeDistributionSummary ds = new CompositeDistributionSummary(name, tags, description, quantiles, histogram);
        this.compositeMeters.add(ds);
        this.registries.forEach(ds::add);
        return ds;
    }

    @Override
    protected Counter newCounter(String name, Iterable<Tag> tags, String description) {
        CompositeCounter counter = new CompositeCounter(name, tags, description);
        this.compositeMeters.add(counter);
        this.registries.forEach(counter::add);
        return counter;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(String name, Iterable<Tag> tags, String description) {
        CompositeLongTaskTimer longTaskTimer = new CompositeLongTaskTimer(name, tags, description);
        this.compositeMeters.add(longTaskTimer);
        this.registries.forEach(longTaskTimer::add);
        return longTaskTimer;
    }

    @Override
    protected <T> Gauge newGauge(String name, Iterable<Tag> tags, String description, ToDoubleFunction<T> f, T obj) {
        CompositeGauge<T> gauge = new CompositeGauge<T>(name, tags, description, obj, f);
        this.compositeMeters.add(gauge);
        this.registries.forEach(gauge::add);
        return gauge;
    }

    @Override
    protected void newMeter(String name, Iterable<Tag> tags, Meter.Type type, Iterable<Measurement> measurements) {
        CompositeCustomMeter meter = new CompositeCustomMeter(name, tags, type, measurements);
        this.compositeMeters.add(meter);
        this.registries.forEach(meter::add);
    }

    public void add(MeterRegistry registry) {
        if (this.registries.add(registry)) {
            this.compositeMeters.forEach(m -> m.add(registry));
        }
    }

    public void remove(MeterRegistry registry) {
        if (this.registries.remove(registry)) {
            this.compositeMeters.forEach(m -> m.remove(registry));
        }
    }
}

