/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeter;
import io.micrometer.core.instrument.noop.NoopTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CompositeTimer
extends AbstractTimer
implements CompositeMeter {
    private final Quantiles quantiles;
    private final Histogram histogram;
    private final Map<MeterRegistry, Timer> timers = Collections.synchronizedMap(new LinkedHashMap());

    CompositeTimer(String name, Iterable<Tag> tags, String description, Quantiles quantiles, Histogram histogram, Clock clock) {
        super(name, tags, description, clock);
        this.quantiles = quantiles;
        this.histogram = histogram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(long amount, TimeUnit unit) {
        Map<MeterRegistry, Timer> map = this.timers;
        synchronized (map) {
            this.timers.values().forEach(ds -> ds.record(amount, unit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        Map<MeterRegistry, Timer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().findFirst().orElse(NoopTimer.INSTANCE).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double totalTime(TimeUnit unit) {
        Map<MeterRegistry, Timer> map = this.timers;
        synchronized (map) {
            return this.timers.values().stream().findFirst().orElse(NoopTimer.INSTANCE).totalTime(unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(MeterRegistry registry) {
        Map<MeterRegistry, Timer> map = this.timers;
        synchronized (map) {
            this.timers.put(registry, registry.timerBuilder(this.getName()).tags(this.getTags()).quantiles(this.quantiles).histogram(this.histogram).create());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MeterRegistry registry) {
        Map<MeterRegistry, Timer> map = this.timers;
        synchronized (map) {
            this.timers.remove(registry);
        }
    }
}

