/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.datadog;

import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.datadog.DatadogConfig;
import io.micrometer.core.instrument.datadog.DatadogNamingConvention;
import io.micrometer.core.instrument.datadog.DatadogRegistry;
import io.micrometer.core.instrument.spectator.step.StepSpectatorMeterRegistry;

public class DatadogMeterRegistry
extends StepSpectatorMeterRegistry {
    public DatadogMeterRegistry(DatadogConfig config, final Clock clock) {
        super((Registry)new DatadogRegistry(config, new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }), clock, config.step().toMillis());
        this.config().namingConvention(new DatadogNamingConvention());
        this.start();
    }

    public DatadogMeterRegistry(DatadogConfig config) {
        this(config, Clock.SYSTEM);
    }

    public void start() {
        this.getDatadogRegistry().start();
    }

    public void stop() {
        this.getDatadogRegistry().stop();
    }

    private DatadogRegistry getDatadogRegistry() {
        return (DatadogRegistry)this.getSpectatorRegistry();
    }
}

