/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import io.micrometer.core.instrument.simple.SimpleLongTaskTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;

public class DropwizardMeterRegistry
extends AbstractMeterRegistry {
    private final MetricRegistry registry = new MetricRegistry();
    private final HierarchicalNameMapper nameMapper;

    public DropwizardMeterRegistry(HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase);
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(String name, Iterable<Tag> tags, String description) {
        return new DropwizardCounter(name, tags, description, this.registry.meter(this.nameMapper.toHierarchicalName(name, tags)));
    }

    @Override
    protected <T> Gauge newGauge(String name, Iterable<Tag> tags, String description, ToDoubleFunction<T> f, T obj) {
        WeakReference ref = new WeakReference(obj);
        com.codahale.metrics.Gauge gauge = () -> f.applyAsDouble(ref.get());
        this.registry.register(this.nameMapper.toHierarchicalName(name, tags), (Metric)gauge);
        return new DropwizardGauge(name, tags, description, (com.codahale.metrics.Gauge<Double>)gauge);
    }

    @Override
    protected Timer newTimer(String name, Iterable<Tag> tags, String description, Histogram<?> histogram, Quantiles quantiles) {
        return new DropwizardTimer(name, tags, description, this.registry.timer(this.nameMapper.toHierarchicalName(name, tags)), this.clock);
    }

    @Override
    protected DistributionSummary newDistributionSummary(String name, Iterable<Tag> tags, String description, Quantiles quantiles, Histogram<?> histogram) {
        return new DropwizardDistributionSummary(name, tags, description, this.registry.histogram(this.nameMapper.toHierarchicalName(name, tags)));
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(String name, Iterable<Tag> tags, String description) {
        SimpleLongTaskTimer ltt = new SimpleLongTaskTimer(name, tags, description, this.clock);
        this.registry.register(this.nameMapper.toHierarchicalName(name, tags) + ".active", (Metric)((com.codahale.metrics.Gauge)ltt::activeTasks));
        this.registry.register(this.nameMapper.toHierarchicalName(name, tags) + ".duration", (Metric)((com.codahale.metrics.Gauge)ltt::duration));
        return ltt;
    }

    @Override
    protected void newMeter(String name, Iterable<Tag> tags, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            com.codahale.metrics.Gauge cfr_ignored_0 = (com.codahale.metrics.Gauge)this.registry.register(this.nameMapper.toHierarchicalName(name, tags), (Metric)((com.codahale.metrics.Gauge)ms::getValue));
        });
    }
}

