/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong(0L);

    DropwizardTimer(String name, Iterable<Tag> tags, String description, Timer impl, Clock clock) {
        super(name, tags, description, clock);
        this.impl = impl;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.impl.update(amount, unit);
            this.totalTime.addAndGet(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.convert(this.totalTime.get(), TimeUnit.NANOSECONDS, unit);
    }
}

