/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteNamingConvention
implements NamingConvention {
    private static final Pattern blacklistedChars = Pattern.compile("[{}(),=\\[\\]/]");

    @Override
    public String name(String name, Meter.Type type, String baseUnit) {
        return this.format(name);
    }

    @Override
    public String tagKey(String key) {
        return this.format(key);
    }

    @Override
    public String tagValue(String value) {
        return this.format(value);
    }

    private String format(String name) {
        String sanitized = Normalizer.normalize(name, Normalizer.Form.NFKD);
        sanitized = NamingConvention.camelCase.tagKey(name);
        return blacklistedChars.matcher(sanitized).replaceAll("_");
    }
}

