/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.influx;

import io.micrometer.core.instrument.spectator.step.StepRegistryConfig;

public interface InfluxConfig
extends StepRegistryConfig {
    @Override
    default public String prefix() {
        return "influx";
    }

    default public String db() {
        String v = this.get(this.prefix() + ".db");
        return v == null ? "mydb" : v;
    }

    default public String consistency() {
        String v = this.get(this.prefix() + ".consistency");
        if (v == null) {
            return "one";
        }
        if (!(v.equals("any") || v.equals("one") || v.equals("quorum") || v.equals("all"))) {
            throw new IllegalArgumentException("Influx consistency must be one of [any, one, quorum, all]");
        }
        return v;
    }

    default public String userName() {
        return this.get(this.prefix() + ".userName");
    }

    default public String password() {
        return this.get(this.prefix() + ".password");
    }

    default public String retentionPolicy() {
        return this.get(this.prefix() + ".retentionPolicy");
    }

    default public String uri() {
        String v = this.get(this.prefix() + "uri");
        return v == null ? "http://localhost:8086/write" : v;
    }

    default public boolean compressed() {
        String v = this.get(this.prefix() + ".compressed");
        return v == null || Boolean.valueOf(v) != false;
    }
}

