/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.influx;

import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.influx.InfluxConfig;
import io.micrometer.core.instrument.influx.InfluxNamingConvention;
import io.micrometer.core.instrument.influx.InfluxRegistry;
import io.micrometer.core.instrument.spectator.step.StepSpectatorMeterRegistry;

public class InfluxMeterRegistry
extends StepSpectatorMeterRegistry {
    public InfluxMeterRegistry(InfluxConfig config, final Clock clock) {
        super((Registry)new InfluxRegistry(config, new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }), clock, config.step().toMillis());
        this.config().namingConvention(new InfluxNamingConvention());
        this.start();
    }

    public InfluxMeterRegistry(InfluxConfig config) {
        this(config, Clock.SYSTEM);
    }

    public void start() {
        this.getInfluxRegistry().start();
    }

    public void stop() {
        this.getInfluxRegistry().stop();
    }

    private InfluxRegistry getInfluxRegistry() {
        return (InfluxRegistry)this.getSpectatorRegistry();
    }
}

