/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.influx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;

public class InfluxNamingConvention
implements NamingConvention {
    @Override
    public String name(String name, Meter.Type type, String baseUnit) {
        return this.format(name.replace("=", "_"));
    }

    @Override
    public String tagKey(String key) {
        if (key.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag key in InfluxDB");
        }
        return this.format(key);
    }

    @Override
    public String tagValue(String value) {
        if (value.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag value in InfluxDB");
        }
        return this.format(value);
    }

    private String format(String name) {
        return NamingConvention.snakeCase.tagKey(name).replace(",", "\\,").replace(" ", "\\ ").replace("=", "\\=").replace("\"", "\\\"");
    }
}

