/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.influx;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import io.micrometer.core.instrument.influx.InfluxConfig;
import io.micrometer.core.instrument.spectator.step.AbstractStepRegistry;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPOutputStream;

public class InfluxRegistry
extends AbstractStepRegistry {
    private final URL influxEndpoint;
    private final String userName;
    private final String password;
    private final boolean compressed;

    public InfluxRegistry(InfluxConfig config, Clock clock) {
        super(config, clock);
        try {
            String queryParams = "?consistency=" + config.consistency() + "&precision=ms&db=" + config.db();
            if (config.retentionPolicy() != null) {
                queryParams = queryParams + "&rp=" + config.retentionPolicy();
            }
            this.influxEndpoint = URI.create(config.uri() + queryParams).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed InfluxDB publishing endpoint, see '" + config.prefix() + ".uri'", e);
        }
        this.userName = config.userName();
        this.password = config.password();
        this.compressed = config.compressed();
    }

    @Override
    protected void pushMetrics() {
        try {
            long time = this.clock().wallTime();
            for (List<Measurement> batch : this.getBatches()) {
                HttpURLConnection con = (HttpURLConnection)this.influxEndpoint.openConnection();
                con.setConnectTimeout(this.connectTimeout);
                con.setReadTimeout(this.readTimeout);
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "plain/text");
                con.setDoOutput(true);
                if (this.userName != null && this.password != null) {
                    String encoded = Base64.getEncoder().encodeToString((this.userName + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                    con.setRequestProperty("Authorization", "Basic " + encoded);
                }
                String body = batch.stream().filter(m -> !Double.isNaN(m.value())).map(m -> {
                    String field = StreamSupport.stream(m.id().tags().spliterator(), false).filter(t -> t.key().equals("statistic")).findAny().map(Tag::value).orElse("value");
                    String tags = StreamSupport.stream(m.id().tags().spliterator(), false).filter(t -> !t.key().equals("statistic")).map(t -> "," + t.key() + "=" + t.value()).collect(Collectors.joining(""));
                    return m.id().name() + tags + " " + field + "=" + m.value() + " " + time;
                }).collect(Collectors.joining("\n"));
                if (this.compressed) {
                    con.setRequestProperty("Content-Encoding", "gzip");
                }
                try (OutputStream os = con.getOutputStream();
                     GZIPOutputStream gz = new GZIPOutputStream(os);){
                    if (this.compressed) {
                        gz.write(body.getBytes());
                        gz.flush();
                    } else {
                        os.write(body.getBytes());
                    }
                    os.flush();
                }
                int status = con.getResponseCode();
                if (status >= 200 && status < 300) {
                    this.logger.info("successfully sent " + batch.size() + " metrics to influx");
                } else if (status >= 400) {
                    try (InputStream in = status >= 400 ? con.getErrorStream() : con.getInputStream();){
                        this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                    }
                } else {
                    this.logger.error("failed to send metrics: http " + status);
                }
                con.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to send metrics", (Throwable)e);
        }
    }
}

