/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.lazy;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class LazyTimer
implements Timer {
    private final Supplier<Timer> timerBuilder;
    private volatile Timer timer;

    private Timer timer() {
        Timer result = this.timer;
        Timer timer = result == null ? (this.timer == null ? (this.timer = this.timerBuilder.get()) : this.timer) : result;
        return timer;
    }

    public LazyTimer(Supplier<Timer> timerBuilder) {
        this.timerBuilder = timerBuilder;
    }

    @Override
    public String getName() {
        return this.timer().getName();
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.timer().getTags();
    }

    @Override
    public String getDescription() {
        return this.timer().getDescription();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.timer().record(amount, unit);
    }

    @Override
    public <T> T record(Supplier<T> f) {
        return this.timer().record(f);
    }

    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        return this.timer().recordCallable(f);
    }

    @Override
    public void record(Runnable f) {
        this.timer().record(f);
    }

    @Override
    public <T> Callable<T> wrap(Callable<T> f) {
        return this.timer().wrap(f);
    }

    @Override
    public long count() {
        return this.timer().count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return this.timer().totalTime(unit);
    }
}

