/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus;

import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.prometheus.PrometheusCounter;
import io.micrometer.core.instrument.prometheus.PrometheusDistributionSummary;
import io.micrometer.core.instrument.prometheus.PrometheusGauge;
import io.micrometer.core.instrument.prometheus.PrometheusLongTaskTimer;
import io.micrometer.core.instrument.prometheus.PrometheusNamingConvention;
import io.micrometer.core.instrument.prometheus.PrometheusTimer;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusCollector;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusLongTaskTimer;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusSummary;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class PrometheusMeterRegistry
extends AbstractMeterRegistry {
    private final CollectorRegistry registry;
    private final ConcurrentMap<String, Collector> collectorMap = new ConcurrentHashMap<String, Collector>();

    public PrometheusMeterRegistry() {
        this(new CollectorRegistry());
    }

    public PrometheusMeterRegistry(CollectorRegistry registry) {
        this(registry, Clock.SYSTEM);
    }

    public PrometheusMeterRegistry(CollectorRegistry registry, Clock clock) {
        super(clock);
        this.registry = registry;
        this.config().namingConvention(new PrometheusNamingConvention());
    }

    public String scrape() {
        StringWriter writer = new StringWriter();
        try {
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    @Override
    public Counter newCounter(String name, Iterable<Tag> tags, String description) {
        io.prometheus.client.Counter counter = this.collectorByName(io.prometheus.client.Counter.class, name, n -> (io.prometheus.client.Counter)this.buildCollector(name, tags, description, (SimpleCollector.Builder)io.prometheus.client.Counter.build()));
        return new PrometheusCounter(name, tags, description, (Counter.Child)this.child(counter, tags));
    }

    @Override
    public DistributionSummary newDistributionSummary(String name, Iterable<Tag> tags, String description, Quantiles quantiles, Histogram<?> histogram) {
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, name, n -> (CustomPrometheusSummary)new CustomPrometheusSummary(name, tags, description).register(this.registry));
        return new PrometheusDistributionSummary(name, tags, description, summary.child(tags, quantiles, histogram));
    }

    @Override
    protected Timer newTimer(String name, Iterable<Tag> tags, String description, Histogram<?> histogram, Quantiles quantiles) {
        CustomPrometheusSummary summary = this.collectorByName(CustomPrometheusSummary.class, name, n -> (CustomPrometheusSummary)new CustomPrometheusSummary(name, tags, description).register(this.registry));
        return new PrometheusTimer(name, tags, description, summary.child(tags, quantiles, histogram), this.config().clock());
    }

    @Override
    protected <T> Gauge newGauge(String name, Iterable<Tag> tags, String description, final ToDoubleFunction<T> f, T obj) {
        final WeakReference<T> ref = new WeakReference<T>(obj);
        io.prometheus.client.Gauge gauge = this.collectorByName(io.prometheus.client.Gauge.class, name, i -> (io.prometheus.client.Gauge)this.buildCollector(name, tags, description, (SimpleCollector.Builder)io.prometheus.client.Gauge.build()));
        String[] labelValues = StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]);
        Gauge.Child child = new Gauge.Child(){

            public double get() {
                Object obj = ref.get();
                return obj == null ? Double.NaN : f.applyAsDouble(obj);
            }
        };
        gauge.setChild((Object)child, labelValues);
        return new PrometheusGauge(name, tags, description, child);
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(String name, Iterable<Tag> tags, String description) {
        CustomPrometheusLongTaskTimer longTaskTimer = this.collectorByName(CustomPrometheusLongTaskTimer.class, name, n -> (CustomPrometheusLongTaskTimer)new CustomPrometheusLongTaskTimer(name, tags, description, this.config().clock()).register(this.registry));
        return new PrometheusLongTaskTimer(name, tags, description, longTaskTimer.child(tags));
    }

    @Override
    protected void newMeter(String name, Iterable<Tag> tags, Meter.Type type, Iterable<Measurement> measurements) {
        CustomPrometheusCollector c = (CustomPrometheusCollector)this.collectorMap.computeIfAbsent(name, name2 -> {
            Collector.Type promType = Collector.Type.UNTYPED;
            switch (type) {
                case Counter: {
                    promType = Collector.Type.COUNTER;
                    break;
                }
                case Gauge: {
                    promType = Collector.Type.GAUGE;
                    break;
                }
                case DistributionSummary: 
                case Timer: {
                    promType = Collector.Type.SUMMARY;
                }
            }
            CustomPrometheusCollector collector = new CustomPrometheusCollector(name, tags, promType);
            this.registry.register((Collector)collector);
            return collector;
        });
        c.child(tags, measurements);
    }

    public CollectorRegistry getPrometheusRegistry() {
        return this.registry;
    }

    private <B extends SimpleCollector.Builder<B, C>, C extends SimpleCollector<D>, D> C buildCollector(String name, Iterable<Tag> tags, String description, SimpleCollector.Builder<B, C> builder) {
        return (C)builder.name(name).help(description == null ? " " : description).labelNames(StreamSupport.stream(tags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList()).toArray(new String[0])).register(this.registry);
    }

    private <C extends SimpleCollector<D>, D> D child(C collector, Iterable<Tag> tags) {
        return (D)collector.labels(StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList()).toArray(new String[0]));
    }

    private <C extends Collector> C collectorByName(Class<C> collectorType, String name, Function<String, C> ifAbsent) {
        Collector collector = this.collectorMap.computeIfAbsent(name, ifAbsent);
        if (!collectorType.isInstance(collector)) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (C)collector;
    }
}

