/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import java.util.regex.Pattern;

public class PrometheusNamingConvention
implements NamingConvention {
    private static final Pattern nameChars = Pattern.compile("[^a-zA-Z0-9_:]");
    private static final Pattern tagKeyChars = Pattern.compile("[^a-zA-Z0-9_]");

    @Override
    public String name(String name, Meter.Type type, String baseUnit) {
        String conventionName = NamingConvention.snakeCase.name(name, type, baseUnit);
        switch (type) {
            case Counter: {
                conventionName = conventionName + "_total";
                break;
            }
            case Timer: {
                if (conventionName.endsWith("_duration")) {
                    conventionName = conventionName + "_seconds";
                    break;
                }
                if (conventionName.endsWith("_seconds")) break;
                conventionName = conventionName + "_duration_seconds";
                break;
            }
            case DistributionSummary: {
                if (baseUnit == null || conventionName.endsWith("_" + baseUnit)) break;
                conventionName = conventionName + "_" + baseUnit;
            }
        }
        String sanitized = nameChars.matcher(conventionName).replaceAll("_");
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m_" + sanitized;
        }
        return sanitized;
    }

    @Override
    public String tagKey(String key) {
        String conventionKey = NamingConvention.snakeCase.tagKey(key);
        String sanitized = tagKeyChars.matcher(conventionKey).replaceAll("_");
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m_" + sanitized;
        }
        return sanitized;
    }
}

