/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.prometheus.internal.CustomPrometheusSummary;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class PrometheusTimer
extends AbstractTimer {
    private CustomPrometheusSummary.Child summary;

    PrometheusTimer(String name, Iterable<Tag> tags, String description, CustomPrometheusSummary.Child summary, Clock clock) {
        super(name, tags, description, clock);
        this.summary = summary;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            double seconds = (double)TimeUnit.NANOSECONDS.convert(amount, unit) / 1.0E9;
            this.summary.observe(seconds);
        }
    }

    @Override
    public long count() {
        return this.summary.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.secondsToUnit(this.summary.sum(), unit);
    }
}

