/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.prometheus.internal;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.prometheus.internal.CustomCollectorChild;
import io.micrometer.core.instrument.stats.hist.Bucket;
import io.micrometer.core.instrument.stats.hist.CumulativeHistogram;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.hist.TimeScaleCumulativeHistogram;
import io.micrometer.core.instrument.stats.hist.TimeScaleNormalHistogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.prometheus.client.Collector;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CustomPrometheusSummary
extends Collector {
    private final String name;
    private final String description;
    private final String countName;
    private final String sumName;
    private final List<String> tagKeys;
    private final Collection<Child> children = new ConcurrentLinkedQueue<Child>();

    public CustomPrometheusSummary(String name, Iterable<Tag> tags, String description) {
        this.name = name;
        this.description = description;
        this.countName = name + "_count";
        this.sumName = name + "_sum";
        this.tagKeys = StreamSupport.stream(tags.spliterator(), false).map(Tag::getKey).collect(Collectors.toList());
    }

    public Child child(Iterable<Tag> tags, Quantiles quantiles, Histogram histogram) {
        Child child = new Child(tags, quantiles, histogram);
        this.children.add(child);
        return child;
    }

    public List<Collector.MetricFamilySamples> collect() {
        Collector.Type type = this.children.stream().anyMatch(c -> ((Child)c).histogram != null) ? Collector.Type.HISTOGRAM : Collector.Type.SUMMARY;
        return Collections.singletonList(new Collector.MetricFamilySamples(this.name, type, this.description == null ? " " : this.description, this.children.stream().flatMap(Child::collect).collect(Collectors.toList())));
    }

    public class Child
    implements CustomCollectorChild {
        private final List<String> tagValues;
        private final Quantiles quantiles;
        private List<String> quantileKeys;
        private Histogram<?> histogram;
        private List<String> histogramKeys;
        private LongAdder count = new LongAdder();
        private DoubleAdder sum = new DoubleAdder();

        Child(Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
            this.quantiles = quantiles;
            this.histogram = histogram;
            this.tagValues = StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
            if (quantiles != null) {
                this.quantileKeys = new LinkedList<String>(CustomPrometheusSummary.this.tagKeys);
                this.quantileKeys.add("quantile");
            }
            if (histogram != null) {
                this.histogramKeys = new LinkedList<String>(CustomPrometheusSummary.this.tagKeys);
                if (histogram instanceof CumulativeHistogram) {
                    this.histogramKeys.add("le");
                } else {
                    this.histogramKeys.add("bucket");
                }
                if (histogram instanceof TimeScaleCumulativeHistogram) {
                    this.histogram = ((TimeScaleCumulativeHistogram)histogram).shiftScale(TimeUnit.SECONDS);
                } else if (histogram instanceof TimeScaleNormalHistogram) {
                    this.histogram = ((TimeScaleNormalHistogram)histogram).shiftScale(TimeUnit.SECONDS);
                }
            }
        }

        @Override
        public Stream<Collector.MetricFamilySamples.Sample> collect() {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            if (this.quantiles != null) {
                for (Double d : this.quantiles.monitored()) {
                    LinkedList<String> quantileValues = new LinkedList<String>(this.tagValues);
                    quantileValues.add(Collector.doubleToGoString((double)d));
                    samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusSummary.this.name, this.quantileKeys, quantileValues, this.quantiles.get(d).doubleValue()));
                }
            }
            if (this.histogram != null) {
                for (Bucket bucket2 : this.histogram.getBuckets()) {
                    LinkedList<String> histogramValues = new LinkedList<String>(this.tagValues);
                    histogramValues.add(bucket2.getTag(bucket -> bucket instanceof Double ? Collector.doubleToGoString((double)((Double)bucket)) : bucket.toString()));
                    samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusSummary.this.name + "_bucket", this.histogramKeys, histogramValues, bucket2.getValue()));
                }
            }
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusSummary.this.countName, CustomPrometheusSummary.this.tagKeys, this.tagValues, (double)this.count.sum()));
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusSummary.this.sumName, CustomPrometheusSummary.this.tagKeys, this.tagValues, this.sum.sum()));
            return samples.build();
        }

        public void observe(double amt) {
            this.count.add(1L);
            this.sum.add(amt);
            if (this.quantiles != null) {
                this.quantiles.observe(amt);
            }
            if (this.histogram != null) {
                this.histogram.observe(amt);
            }
        }

        public long count() {
            return this.count.sum();
        }

        public double sum() {
            return this.sum.sum();
        }
    }
}

