/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.AbstractSimpleMeter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class SimpleDistributionSummary
extends AbstractSimpleMeter
implements DistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();

    public SimpleDistributionSummary(String name, Iterable<Tag> tags, String description) {
        super(name, tags, description, Meter.Type.DistributionSummary);
    }

    @Override
    public void record(double amount) {
        if (amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

