/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.simple;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class SimpleTimer
extends AbstractTimer {
    private LongAdder count = new LongAdder();
    private LongAdder totalTime = new LongAdder();

    public SimpleTimer(String name, Iterable<Tag> tags, String description, Clock clock) {
        super(name, tags, description, clock);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.count.increment();
            this.totalTime.add(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }
}

