/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.Meter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.spectator.SpectatorUtils;
import io.micrometer.core.instrument.util.MeterEquivalence;

public class SpectatorCounter
implements Counter {
    private com.netflix.spectator.api.Counter counter;
    private final String description;

    public SpectatorCounter(com.netflix.spectator.api.Counter counter, String description) {
        this.counter = counter;
        this.description = description;
    }

    @Override
    public void increment(double amount) {
        this.counter.increment((long)amount);
    }

    @Override
    public double count() {
        return this.counter.count();
    }

    @Override
    public String getName() {
        return this.counter.id().name();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Iterable<Tag> getTags() {
        return SpectatorUtils.tags((Meter)this.counter);
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

