/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.AbstractMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.spectator.CustomSpectatorToDoubleGauge;
import io.micrometer.core.instrument.spectator.SpectatorCounter;
import io.micrometer.core.instrument.spectator.SpectatorDistributionSummary;
import io.micrometer.core.instrument.spectator.SpectatorGauge;
import io.micrometer.core.instrument.spectator.SpectatorLongTaskTimer;
import io.micrometer.core.instrument.spectator.SpectatorTimer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class SpectatorMeterRegistry
extends AbstractMeterRegistry {
    private final Registry registry;

    public SpectatorMeterRegistry(Registry registry, Clock clock) {
        super(clock);
        this.registry = registry;
    }

    private Collection<com.netflix.spectator.api.Tag> toSpectatorTags(Iterable<Tag> tags) {
        return StreamSupport.stream(tags.spliterator(), false).map(t -> new BasicTag(t.getKey(), t.getValue())).collect(Collectors.toList());
    }

    @Override
    protected Counter newCounter(String name, Iterable<Tag> tags, String description) {
        com.netflix.spectator.api.Counter counter = this.registry.counter(name, this.toSpectatorTags(tags));
        return new SpectatorCounter(counter, description);
    }

    @Override
    protected DistributionSummary newDistributionSummary(String name, Iterable<Tag> tags, String description, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles, UnaryOperator.identity());
        com.netflix.spectator.api.DistributionSummary ds = this.registry.distributionSummary(name, this.toSpectatorTags(tags));
        return new SpectatorDistributionSummary(ds, description);
    }

    @Override
    protected Timer newTimer(String name, Iterable<Tag> tags, String description, Histogram<?> histogram, Quantiles quantiles) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles, t -> t / 1000000.0);
        this.registerHistogramCounterIfNecessary(name, tags, histogram);
        com.netflix.spectator.api.Timer timer = this.registry.timer(name, this.toSpectatorTags(tags));
        return new SpectatorTimer(timer, description, quantiles, this.config().clock());
    }

    @Override
    protected <T> Gauge newGauge(String name, Iterable<Tag> tags, String description, ToDoubleFunction<T> f, T obj) {
        Id gaugeId = this.registry.createId(name, this.toSpectatorTags(tags));
        CustomSpectatorToDoubleGauge<T> gauge = new CustomSpectatorToDoubleGauge<T>(this.registry.clock(), gaugeId, obj, f);
        this.registry.register(gauge);
        return new SpectatorGauge(gauge, description);
    }

    private void registerHistogramCounterIfNecessary(String name, Iterable<Tag> tags, Histogram<?> histogram) {
    }

    private void registerQuantilesGaugeIfNecessary(String name, Iterable<Tag> tags, Quantiles quantiles, UnaryOperator<Double> scaling) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                LinkedList<com.netflix.spectator.api.Tag> quantileTags = new LinkedList<com.netflix.spectator.api.Tag>(this.toSpectatorTags(tags));
                if (Double.isNaN(q)) continue;
                quantileTags.add((com.netflix.spectator.api.Tag)new BasicTag("quantile", Double.toString(q)));
                quantileTags.add((com.netflix.spectator.api.Tag)new BasicTag("statistic", "value"));
                this.registry.gauge(this.registry.createId(name, quantileTags), (Object)q, q2 -> (Double)scaling.apply(quantiles.get((double)q2)));
            }
        }
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(String name, Iterable<Tag> tags, String description) {
        com.netflix.spectator.api.LongTaskTimer timer = this.registry.longTaskTimer(name, this.toSpectatorTags(tags));
        return new SpectatorLongTaskTimer(timer, description);
    }

    @Override
    protected void newMeter(final String name, final Iterable<Tag> tags, Meter.Type type, final Iterable<Measurement> measurements) {
        Id spectatorId = SpectatorMeterRegistry.spectatorId(this.registry, name, tags);
        AbstractMeter<Id> spectatorMeter = new AbstractMeter<Id>(this.registry.clock(), spectatorId, spectatorId){

            public Iterable<com.netflix.spectator.api.Measurement> measure() {
                return StreamSupport.stream(measurements.spliterator(), false).map(m -> new com.netflix.spectator.api.Measurement(SpectatorMeterRegistry.spectatorId(SpectatorMeterRegistry.this.registry, name, tags), this.clock.wallTime(), m.getValue())).collect(Collectors.toList());
            }
        };
        this.registry.register((Meter)spectatorMeter);
    }

    public Registry getSpectatorRegistry() {
        return this.registry;
    }

    private static Id spectatorId(Registry registry, String name, Iterable<Tag> tags) {
        String[] flattenedTags = (String[])StreamSupport.stream(tags.spliterator(), false).flatMap(t -> Stream.of(t.getKey(), t.getValue())).toArray(String[]::new);
        return registry.createId(name, flattenedTags);
    }
}

