/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.spectator.step;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Statistic;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.Supplier;

class StepMeasurement
extends Measurement {
    private final StepDouble value;
    private final DoubleAdder lastCount = new DoubleAdder();
    private final Supplier<Double> f;

    public StepMeasurement(Supplier<Double> f, Statistic statistic, Clock clock, long step) {
        super(f, statistic);
        this.f = f;
        this.value = new StepDouble(clock, step);
    }

    @Override
    public double getValue() {
        double absoluteCount = this.f.get();
        double inc = Math.max(0.0, absoluteCount - this.lastCount.sum());
        this.lastCount.add(inc);
        this.value.getCurrent().add(inc);
        return this.value.poll();
    }

    private class StepDouble {
        private final Clock clock;
        private final long step;
        private volatile double previous = 0.0;
        private final DoubleAdder current = new DoubleAdder();
        private final AtomicLong lastInitPos;

        StepDouble(Clock clock, long step) {
            this.clock = clock;
            this.step = step;
            this.lastInitPos = new AtomicLong(clock.wallTime() / step);
        }

        private void rollCount(long now) {
            long stepTime = now / this.step;
            long lastInit = this.lastInitPos.get();
            if (lastInit < stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
                double v = this.current.sumThenReset();
                this.previous = lastInit == stepTime - 1L ? v : 0.0;
            }
        }

        public DoubleAdder getCurrent() {
            return this.current;
        }

        double poll() {
            this.rollCount(this.clock.wallTime());
            return this.previous;
        }
    }
}

