/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.stats.quantile;

import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class Frugal2UQuantiles
implements Quantiles {
    private final Quantile[] quantiles;
    private final Collection<Double> registered;

    Frugal2UQuantiles(Quantile[] quantiles) {
        this.quantiles = quantiles;
        this.registered = new ArrayList<Double>();
        for (Quantile quantile : quantiles) {
            this.registered.add(quantile.q);
        }
    }

    @Override
    public void observe(double value) {
        for (Quantile q : this.quantiles) {
            q.insert(value);
        }
    }

    @Override
    public Double get(double q) {
        for (Quantile quantile : this.quantiles) {
            if (quantile.q != q) continue;
            return quantile.m;
        }
        return 0.0;
    }

    @Override
    public Collection<Double> monitored() {
        return this.registered;
    }

    public Quantile[] getQuantiles() {
        return this.quantiles;
    }

    public static Builder quantile(double quantile, double estimate) {
        return new Builder().quantile(quantile, estimate);
    }

    public static class Builder {
        List<Quantile> quantiles = new ArrayList<Quantile>();

        public Builder quantile(double quantile, double estimate) {
            this.quantiles.add(new Quantile(quantile, estimate));
            return this;
        }

        public Frugal2UQuantiles create() {
            return new Frugal2UQuantiles(this.quantiles.toArray(new Quantile[this.quantiles.size()]));
        }
    }

    static class Quantile {
        double m;
        double q;
        int step = 1;
        int sign = 0;
        Random r = new Random(new Random().nextInt());

        Quantile(double quantile, double estimate) {
            this.m = estimate;
            this.q = quantile;
        }

        void insert(double s) {
            if (this.sign == 0) {
                this.m = s;
                this.sign = 1;
                return;
            }
            double rnd = this.r.nextDouble();
            if (s > this.m && rnd > 1.0 - this.q) {
                this.step += this.sign * this.f(this.step);
                this.m = this.step > 0 ? (this.m += (double)this.step) : (this.m += 1.0);
                if (this.m > s) {
                    this.step = (int)((double)this.step + (s - this.m));
                    this.m = s;
                }
                if (this.sign < 0 && this.step > 1) {
                    this.step = 1;
                }
                this.sign = 1;
            } else if (s < this.m && rnd > this.q) {
                this.step += -this.sign * this.f(this.step);
                this.m = this.step > 0 ? (this.m -= (double)this.step) : (this.m -= 1.0);
                if (this.m < s) {
                    this.step = (int)((double)this.step + (this.m - s));
                    this.m = s;
                }
                if (this.sign > 0 && this.step > 1) {
                    this.step = 1;
                }
                this.sign = -1;
            }
        }

        int f(int step) {
            return 1;
        }
    }
}

