/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractMeterRegistry
implements MeterRegistry {
    protected final Clock clock;
    private final List<Tag> commonTags = new ArrayList<Tag>();
    private final ConcurrentMap<Meter.Id, Meter> meterMap = new ConcurrentHashMap<Meter.Id, Meter>();
    private NamingConvention namingConvention = NamingConvention.snakeCase;
    private MeterRegistry.Config config = new MeterRegistry.Config(){

        @Override
        public MeterRegistry.Config commonTags(Iterable<Tag> tags) {
            StreamSupport.stream(tags.spliterator(), false).map(t -> Tag.of(AbstractMeterRegistry.this.namingConvention.tagKey(t.getKey()), AbstractMeterRegistry.this.namingConvention.tagValue(t.getValue()))).forEach(AbstractMeterRegistry.this.commonTags::add);
            return this;
        }

        @Override
        public Iterable<Tag> commonTags() {
            return AbstractMeterRegistry.this.commonTags;
        }

        @Override
        public MeterRegistry.Config namingConvention(NamingConvention convention) {
            AbstractMeterRegistry.this.namingConvention = convention;
            return this;
        }

        @Override
        public NamingConvention namingConvention() {
            return AbstractMeterRegistry.this.namingConvention;
        }

        @Override
        public Clock clock() {
            return AbstractMeterRegistry.this.clock;
        }
    };
    private MeterRegistry.More more = new MeterRegistry.More(){

        @Override
        public LongTaskTimer longTaskTimer(Meter.Id id) {
            return (LongTaskTimer)AbstractMeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, id, id2 -> {
                id2.setType(Meter.Type.LongTaskTimer);
                return AbstractMeterRegistry.this.newLongTaskTimer((Meter.Id)id2);
            });
        }

        public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
            return this.longTaskTimer(AbstractMeterRegistry.this.createId(name, tags, null));
        }

        @Override
        public <T> Meter counter(Meter.Id id, T obj, ToDoubleFunction<T> f) {
            WeakReference ref = new WeakReference(obj);
            return AbstractMeterRegistry.this.register(id, Meter.Type.Counter, Collections.singletonList(new Measurement(() -> {
                Object obj2 = ref.get();
                return obj2 != null ? f.applyAsDouble(obj2) : 0.0;
            }, Statistic.Count)));
        }

        @Override
        public <T> Gauge timeGauge(Meter.Id id, T obj, TimeUnit fUnit, ToDoubleFunction<T> f) {
            return (Gauge)AbstractMeterRegistry.this.registerMeterIfNecessary(Gauge.class, id, id2 -> {
                id2.setType(Meter.Type.Gauge);
                return AbstractMeterRegistry.this.newTimeGauge((Meter.Id)id2, obj, fUnit, f);
            });
        }
    };

    @Override
    public MeterRegistry.Config config() {
        return this.config;
    }

    public AbstractMeterRegistry(Clock clock) {
        this.clock = clock;
    }

    protected abstract <T> Gauge newGauge(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected abstract Counter newCounter(Meter.Id var1);

    protected abstract LongTaskTimer newLongTaskTimer(Meter.Id var1);

    protected abstract Timer newTimer(Meter.Id var1, Histogram.Builder<?> var2, Quantiles var3);

    protected abstract DistributionSummary newDistributionSummary(Meter.Id var1, Histogram.Builder<?> var2, Quantiles var3);

    protected abstract void newMeter(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    protected abstract <T> Gauge newTimeGauge(Meter.Id var1, T var2, TimeUnit var3, ToDoubleFunction<T> var4);

    @Override
    public Meter register(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return this.meterMap.computeIfAbsent(id, id2 -> {
            id2.setType(type);
            this.newMeter((Meter.Id)id2, type, measurements);
            return new Meter((Meter.Id)id2, type, measurements){
                final /* synthetic */ Meter.Id val$id2;
                final /* synthetic */ Meter.Type val$type;
                final /* synthetic */ Iterable val$measurements;
                {
                    this.val$id2 = id;
                    this.val$type = type;
                    this.val$measurements = iterable;
                }

                @Override
                public Meter.Id getId() {
                    return this.val$id2;
                }

                @Override
                public Meter.Type getType() {
                    return this.val$type;
                }

                @Override
                public Iterable<Measurement> measure() {
                    return this.val$measurements;
                }
            };
        });
    }

    @Override
    public Counter counter(Meter.Id id) {
        return this.registerMeterIfNecessary(Counter.class, id, id2 -> {
            id2.setType(Meter.Type.Counter);
            return this.newCounter((Meter.Id)id2);
        });
    }

    @Override
    public <T> Gauge gauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        return this.registerMeterIfNecessary(Gauge.class, id, id2 -> {
            id2.setType(Meter.Type.Gauge);
            return this.newGauge((Meter.Id)id2, obj, f);
        });
    }

    @Override
    public Timer timer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        return this.registerMeterIfNecessary(Timer.class, id, id2 -> {
            id2.setType(Meter.Type.Timer);
            return this.newTimer((Meter.Id)id2, histogram, quantiles);
        });
    }

    @Override
    public DistributionSummary summary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        return this.registerMeterIfNecessary(DistributionSummary.class, id, id2 -> {
            id2.setType(Meter.Type.DistributionSummary);
            return this.newDistributionSummary((Meter.Id)id2, histogram, quantiles);
        });
    }

    @Override
    public MeterRegistry.More more() {
        return this.more;
    }

    @Override
    public MeterRegistry.Search find(String name) {
        return new SearchImpl(name);
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, Function<Meter.Id, Meter> builder) {
        ConcurrentMap<Meter.Id, Meter> concurrentMap = this.meterMap;
        synchronized (concurrentMap) {
            MeterId idWithCommonTags = new MeterId(id.getName(), Tags.concat(id.getTags(), this.config().commonTags()), id.getBaseUnit(), id.getDescription());
            Meter m = this.meterMap.computeIfAbsent(idWithCommonTags, builder);
            if (!meterClass.isInstance(m)) {
                throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
            }
            return (M)m;
        }
    }

    @Override
    public Meter.Id createId(String name, Iterable<Tag> tag, String description, String baseUnit) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must be non-empty");
        }
        return new MeterId(name, tag, baseUnit, description);
    }

    class MeterId
    implements Meter.Id {
        private final String name;
        private final List<Tag> tags;
        private String baseUnit;
        private final String description;
        private Meter.Type type;

        MeterId(String name, Iterable<Tag> tags, String baseUnit, String description) {
            this.name = name;
            this.tags = Stream.concat(StreamSupport.stream(tags.spliterator(), false), AbstractMeterRegistry.this.commonTags.stream()).collect(Collectors.toList());
            this.baseUnit = baseUnit;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Iterable<Tag> getTags() {
            return this.tags;
        }

        @Override
        public String getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public String getConventionName() {
            return AbstractMeterRegistry.this.namingConvention.name(this.name, this.type, this.baseUnit);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public List<Tag> getConventionTags() {
            return this.tags.stream().map(t -> Tag.of(AbstractMeterRegistry.this.namingConvention.tagKey(t.getKey()), AbstractMeterRegistry.this.namingConvention.tagValue(t.getValue()))).sorted(Comparator.comparing(Tag::getKey)).collect(Collectors.toList());
        }

        public String toString() {
            return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MeterId meterId = (MeterId)o;
            return (this.name != null ? this.name.equals(meterId.name) : meterId.name == null) && (this.tags != null ? this.tags.equals(meterId.tags) : meterId.tags == null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }

        @Override
        public void setType(Meter.Type type) {
            this.type = type;
        }

        @Override
        public void setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
        }
    }

    private class SearchImpl
    implements MeterRegistry.Search {
        private final String name;
        private List<Tag> tags = new ArrayList<Tag>();
        private Map<Statistic, Double> valueAsserts = new HashMap<Statistic, Double>();

        SearchImpl(String name) {
            this.name = name;
        }

        @Override
        public MeterRegistry.Search tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        @Override
        public MeterRegistry.Search value(Statistic statistic, double value) {
            this.valueAsserts.put(statistic, value);
            return this;
        }

        @Override
        public Optional<Timer> timer() {
            return this.meters().stream().filter(m -> m instanceof Timer).findAny().map(Timer.class::cast);
        }

        @Override
        public Optional<Counter> counter() {
            return this.meters().stream().filter(m -> m instanceof Counter).findAny().map(Counter.class::cast);
        }

        @Override
        public Optional<Gauge> gauge() {
            return this.meters().stream().filter(m -> m instanceof Gauge).findAny().map(Gauge.class::cast);
        }

        @Override
        public Optional<DistributionSummary> summary() {
            return this.meters().stream().filter(m -> m instanceof DistributionSummary).findAny().map(DistributionSummary.class::cast);
        }

        @Override
        public Optional<LongTaskTimer> longTaskTimer() {
            return this.meters().stream().filter(m -> m instanceof LongTaskTimer).findAny().map(LongTaskTimer.class::cast);
        }

        @Override
        public Optional<Meter> meter() {
            return AbstractMeterRegistry.this.meterMap.keySet().stream().filter(id -> id.getName().equals(this.name)).filter(id -> {
                if (this.tags.isEmpty()) {
                    return true;
                }
                ArrayList idTags = new ArrayList();
                id.getTags().forEach(idTags::add);
                return idTags.containsAll(this.tags);
            }).map(AbstractMeterRegistry.this.meterMap::get).filter(m -> {
                if (this.valueAsserts.isEmpty()) {
                    return true;
                }
                for (Measurement measurement : m.measure()) {
                    if (this.valueAsserts.getOrDefault((Object)measurement.getStatistic(), measurement.getValue()).doubleValue() == measurement.getValue()) continue;
                    return false;
                }
                return true;
            }).findAny();
        }

        @Override
        public Collection<Meter> meters() {
            return AbstractMeterRegistry.this.meterMap.keySet().stream().filter(id -> id.getName().equals(this.name)).filter(id -> {
                ArrayList idTags = new ArrayList();
                id.getTags().forEach(idTags::add);
                return idTags.containsAll(this.tags);
            }).map(AbstractMeterRegistry.this.meterMap::get).collect(Collectors.toList());
        }
    }
}

