/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;

public class JvmThreadMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmThreadMetrics() {
        this(Collections.emptyList());
    }

    public JvmThreadMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        registry.gauge(registry.createId("jvm.threads.peak", this.tags, "the peak live thread count since the Java virtual machine started or peak was reset"), threadBean, ThreadMXBean::getPeakThreadCount);
        registry.gauge(registry.createId("jvm.threads.daemon", this.tags, "The current number of live daemon threads"), threadBean, ThreadMXBean::getDaemonThreadCount);
        registry.gauge(registry.createId("jvm.threads.live", this.tags, "The current number of live threads including both daemon and non-daemon threads"), threadBean, ThreadMXBean::getThreadCount);
    }
}

